/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.blazemeter.api.explorer.Account;
import com.blazemeter.api.explorer.User;
import com.blazemeter.api.explorer.Workspace;
import com.blazemeter.api.explorer.test.AbstractTest;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.blazemeter.AbstractTestComparator;
import hudson.plugins.blazemeter.BlazemeterCredentials;
import hudson.plugins.blazemeter.BlazemeterCredentialsBAImpl;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.ProxyConfigurator;
import hudson.plugins.blazemeter.utils.JenkinsBlazeMeterUtils;
import hudson.plugins.blazemeter.utils.JenkinsTestListFlow;
import hudson.plugins.blazemeter.utils.logger.BzmServerLogger;
import hudson.plugins.blazemeter.utils.notifier.BzmServerNotifier;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Symbol(value={"blazeMeterTest"})
@Extension
public class BlazeMeterPerformanceBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    private static final Logger LOGGER = Logger.getLogger(BlazeMeterPerformanceBuilderDescriptor.class.getName());
    private String NO_CREDENTIALS = "No Credentials";
    private String NO_WORKSPACE = "No Workspace";
    private String SELECT_WORKSPACE = "Select workspace";
    private String SELECT_TEST = "Select test";
    private String NO_TESTS_IN_WORKSPACE = "No tests in workspace";
    private String NO_WORKSPACES_IN_ACCOUNT = "No workspaces in account";
    private String CHECK_CREDENTIALS_PROXY = "Check credentials, proxy settings";
    private String blazeMeterURL = "https://a.blazemeter.com";
    private String name = "My BlazeMeter Account";
    private static BlazeMeterPerformanceBuilderDescriptor descriptor;
    public static String NO_TESTS;

    public BlazeMeterPerformanceBuilderDescriptor() {
        super(PerformanceBuilder.class);
        this.load();
        descriptor = this;
    }

    public BlazeMeterPerformanceBuilderDescriptor(String blazeMeterURL) {
        super(PerformanceBuilder.class);
        this.load();
        this.blazeMeterURL = blazeMeterURL;
        descriptor = this;
    }

    public static BlazeMeterPerformanceBuilderDescriptor getDescriptor() {
        return descriptor;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "BlazeMeter";
    }

    public FormValidation doCheckMainTestFile(@QueryParameter String value) {
        if (StringUtils.isEmpty((String)value) || value.endsWith(".jmx") || value.endsWith(".yml") || value.endsWith(".yaml")) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Unknown script type. Please, select 'Test type' in BlazeMeter web application");
    }

    public ListBoxModel doFillTestIdItems(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="workspaceId") String workspaceId, @QueryParameter(value="testId") String testId) throws FormValidation {
        ListBoxModel items = new ListBoxModel();
        try {
            BlazemeterCredentialsBAImpl credentials;
            List<BlazemeterCredentialsBAImpl> creds = this.getCredentials();
            BlazemeterCredentialsBAImpl blazemeterCredentialsBAImpl = credentials = StringUtils.isBlank((String)credentialsId) && !creds.isEmpty() ? creds.get(0) : this.findCredentials(creds, credentialsId);
            if (credentials != null) {
                Workspace workspace;
                JenkinsBlazeMeterUtils utils = BlazeMeterPerformanceBuilderDescriptor.getBzmUtils(credentials.getUsername(), credentials.getPassword().getPlainText());
                if (StringUtils.isBlank((String)workspaceId)) {
                    List<Workspace> workspaces = this.getWorkspaces(utils);
                    if (workspaces.isEmpty()) {
                        items.add((Object)new ListBoxModel.Option(this.NO_WORKSPACE, testId, true));
                        return items;
                    }
                    workspace = workspaces.get(0);
                } else {
                    workspace = this.getWorkspace(utils, workspaceId);
                }
                if (workspace != null) {
                    items = this.testsList(workspace, testId);
                } else {
                    items.add((Object)new ListBoxModel.Option(this.NO_WORKSPACE, testId, true));
                }
            } else {
                items.add((Object)new ListBoxModel.Option(this.NO_CREDENTIALS, testId, true));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot do fill tests ", ex);
            items.clear();
            items.add((Object)new ListBoxModel.Option(this.CHECK_CREDENTIALS_PROXY, testId, true));
        }
        return items;
    }

    private Workspace getWorkspace(BlazeMeterUtils utils, String workspaceId) throws Exception {
        try {
            return Workspace.getWorkspace((BlazeMeterUtils)utils, (String)workspaceId);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot get workspace with id=" + workspaceId, ex);
            if (ex.getMessage().toLowerCase().contains("not found")) {
                return null;
            }
            throw ex;
        }
    }

    private ListBoxModel testsList(Workspace workspace, String testId) throws Exception {
        ListBoxModel sortedTests = new ListBoxModel();
        JenkinsTestListFlow jenkinsTestListFlow = new JenkinsTestListFlow(workspace.getUtils(), System.getProperty("bzm.limit", "10000"));
        List<AbstractTest> tests = jenkinsTestListFlow.getAllTestsForWorkspaceWithException(workspace);
        AbstractTestComparator c = new AbstractTestComparator();
        if (tests.isEmpty()) {
            sortedTests.add((Object)new ListBoxModel.Option(this.NO_TESTS_IN_WORKSPACE, testId, true));
            return sortedTests;
        }
        Collections.sort(tests, c);
        for (AbstractTest t : tests) {
            String testName = t.getName() + "(" + t.getId() + "." + t.getTestType() + ")";
            sortedTests.add((Object)new ListBoxModel.Option(testName, t.getId() + "." + t.getTestType(), false));
        }
        if (StringUtils.isBlank((String)testId)) {
            ((ListBoxModel.Option)sortedTests.get((int)0)).selected = true;
        }
        for (ListBoxModel.Option test : sortedTests) {
            if (!test.value.contains(testId)) continue;
            test.selected = true;
            return sortedTests;
        }
        sortedTests.add(0, (Object)new ListBoxModel.Option(this.SELECT_TEST, testId, true));
        return sortedTests;
    }

    private List<Workspace> getWorkspaces(BlazeMeterUtils utils) throws IOException {
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        User user = User.getUser((BlazeMeterUtils)utils);
        List accounts = user.getAccounts();
        for (Account acc : accounts) {
            try {
                workspaces.addAll(acc.getWorkspaces());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot get workspaces for account=" + acc.getId(), ex);
            }
        }
        return workspaces;
    }

    public ListBoxModel doFillWorkspaceIdItems(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="workspaceId") String workspaceId) throws FormValidation {
        ListBoxModel items = new ListBoxModel();
        try {
            BlazemeterCredentialsBAImpl credentials;
            List<BlazemeterCredentialsBAImpl> creds = this.getCredentials();
            BlazemeterCredentialsBAImpl blazemeterCredentialsBAImpl = credentials = StringUtils.isBlank((String)credentialsId) && !creds.isEmpty() ? creds.get(0) : this.findCredentials(creds, credentialsId);
            if (credentials != null) {
                JenkinsBlazeMeterUtils utils = BlazeMeterPerformanceBuilderDescriptor.getBzmUtils(credentials.getUsername(), credentials.getPassword().getPlainText());
                items = this.workspacesList(utils, workspaceId);
            } else {
                items.add((Object)new ListBoxModel.Option(this.NO_CREDENTIALS, workspaceId, true));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot do fill workspaces ", ex);
            items.clear();
            items.add((Object)new ListBoxModel.Option(this.CHECK_CREDENTIALS_PROXY, workspaceId, true));
        }
        return items;
    }

    private ListBoxModel workspacesList(BlazeMeterUtils utils, String savedWorkspace) throws Exception {
        ListBoxModel workspacesList = new ListBoxModel();
        List<Workspace> workspaces = this.getWorkspaces(utils);
        for (Workspace ws : workspaces) {
            workspacesList.add((Object)new ListBoxModel.Option(ws.getName() + "(" + ws.getId() + ")", ws.getId(), false));
        }
        if (workspacesList.isEmpty()) {
            workspacesList.add((Object)new ListBoxModel.Option(this.NO_WORKSPACES_IN_ACCOUNT, savedWorkspace, false));
            return workspacesList;
        }
        if (StringUtils.isBlank((String)savedWorkspace)) {
            ((ListBoxModel.Option)workspacesList.get((int)0)).selected = true;
            return workspacesList;
        }
        for (ListBoxModel.Option wsp : workspacesList) {
            if (!wsp.value.contains(savedWorkspace)) continue;
            wsp.selected = true;
            return workspacesList;
        }
        workspacesList.add(0, (Object)new ListBoxModel.Option(this.SELECT_WORKSPACE, savedWorkspace, true));
        return workspacesList;
    }

    public ListBoxModel doFillCredentialsIdItems(@QueryParameter(value="credentialsId") String credentialsId) {
        ListBoxModel items = new ListBoxModel();
        try {
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            List credentials = CredentialsProvider.lookupCredentials(BlazemeterCredentialsBAImpl.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
            for (BlazemeterCredentials c : credentials) {
                items.add((Object)new ListBoxModel.Option(c.getDescription(), c.getId(), false));
            }
            if (StringUtils.isBlank((String)credentialsId)) {
                ((ListBoxModel.Option)items.get((int)0)).selected = true;
                return items;
            }
            for (ListBoxModel.Option option : items) {
                try {
                    if (!credentialsId.equals(option.value)) continue;
                    option.selected = true;
                    return items;
                }
                catch (Exception e) {
                    option.selected = false;
                }
            }
            items.add(0, (Object)new ListBoxModel.Option("Credentials not found '" + credentialsId + "'", credentialsId, true));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot do fill credentials ", ex);
        }
        return items;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String blazeMeterURL = formData.optString("blazeMeterURL");
        this.blazeMeterURL = blazeMeterURL.isEmpty() ? "https://a.blazemeter.com" : blazeMeterURL;
        this.save();
        return true;
    }

    private List<BlazemeterCredentialsBAImpl> getCredentials() {
        return CredentialsProvider.lookupCredentials(BlazemeterCredentialsBAImpl.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    public BlazemeterCredentialsBAImpl findCredentials(List<BlazemeterCredentialsBAImpl> credentials, String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        for (BlazemeterCredentialsBAImpl cred : credentials) {
            if (!cred.getId().equals(credentialsId)) continue;
            return cred;
        }
        return null;
    }

    public static JenkinsBlazeMeterUtils getBzmUtils(String username, String password) throws Exception {
        BzmServerNotifier serverUserNotifier = new BzmServerNotifier();
        BzmServerLogger logger = new BzmServerLogger();
        ProxyConfigurator.updateProxySettings(ProxyConfiguration.load(), false);
        return new JenkinsBlazeMeterUtils(username, password, BlazeMeterPerformanceBuilderDescriptor.descriptor.blazeMeterURL, serverUserNotifier, logger);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBlazeMeterURL() {
        return this.blazeMeterURL;
    }

    public void setBlazeMeterURL(String blazeMeterURL) {
        this.blazeMeterURL = blazeMeterURL;
    }

    static {
        NO_TESTS = "no-tests";
    }
}

