/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.blazemeter.api.explorer.Master;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.blazemeter.ciworkflow.BuildResult;
import com.blazemeter.ciworkflow.CiBuild;
import com.blazemeter.ciworkflow.CiPostProcess;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.ProxyConfigurator;
import hudson.plugins.blazemeter.utils.JenkinsBlazeMeterUtils;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.plugins.blazemeter.utils.logger.BzmServerLogger;
import hudson.plugins.blazemeter.utils.notifier.BzmJobNotifier;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

public class BzmBuild
extends MasterToSlaveCallable<Result, Exception>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(BzmBuild.class.getName());
    private PerformanceBuilder builder;
    private CiPostProcess ciPostProcess;
    private String jobName;
    private String buildId;
    private String apiId;
    private String apiSecret;
    private String serverURL;
    private EnvVars envVars;
    private FilePath workspace;
    private TaskListener listener;
    private Master master;
    private CiBuild build;
    private String mainTestFile;
    private String additionalTestFiles;
    private boolean isSlave;
    private ProxyConfiguration proxyConfiguration;
    private long reportLinkId;
    private String reportLinkName;
    private boolean isUnstableIfHasFails;
    private String SLACK = "slack";
    private String TEAMS = "teams";

    public BzmBuild(PerformanceBuilder builder, String apiId, String apiSecret, String jobName, String buildId, String serverURL, EnvVars envVars, FilePath workspace, TaskListener listener, ProxyConfiguration proxyConfiguration, boolean isSlave, String reportLinkName, long reportLinkId, String mainTestFile, String additionalTestFiles, boolean isUnstableIfHasFails) {
        this.builder = builder;
        this.apiId = apiId;
        this.apiSecret = apiSecret;
        this.jobName = jobName;
        this.buildId = buildId;
        this.serverURL = serverURL;
        this.envVars = envVars;
        this.workspace = workspace;
        this.listener = listener;
        this.proxyConfiguration = proxyConfiguration;
        this.isSlave = isSlave;
        this.reportLinkName = reportLinkName;
        this.reportLinkId = reportLinkId;
        this.mainTestFile = mainTestFile;
        this.additionalTestFiles = additionalTestFiles;
        this.isUnstableIfHasFails = isUnstableIfHasFails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result call() throws Exception {
        ProxyConfigurator.updateProxySettings(this.proxyConfiguration, this.isSlave);
        PrintStream logger = this.listener.getLogger();
        FilePath wsp = this.createWorkspaceDir(this.workspace);
        logger.println(BzmJobNotifier.formatMessage("BlazemeterJenkins plugin v." + Utils.version()));
        JenkinsBlazeMeterUtils utils = this.createBzmUtils();
        try {
            block15: {
                this.build = this.createCiBuild(utils, wsp);
                try {
                    this.build.setWorkspaceId(this.builder.getWorkspaceId());
                    this.master = this.build.start();
                    if (this.master != null) {
                        String runId = this.jobName + "-" + this.buildId + "-" + this.reportLinkId;
                        EnvVars.masterEnvVars.put(runId, this.master.getId());
                        this.createGlobalEnvironmentVariables("masterId", this.master.getId());
                        EnvVars.masterEnvVars.put(runId + "-" + this.master.getId(), this.build.getPublicReport());
                        this.putLinkName(runId);
                        this.build.waitForFinish(this.master);
                        if (this.SLACK.equals(this.builder.getSelectWebhook())) {
                            Optional.ofNullable(this.builder.getWebhookUrl()).filter(webhookUrl -> !webhookUrl.isEmpty()).ifPresent(webhookUrl -> this.sendWebhookNotificationSlack(this.master.getId(), this.build.getCurrentTest().getName(), this.build.getPublicReport(), (String)webhookUrl));
                        } else if (this.TEAMS.equals(this.builder.getSelectWebhook())) {
                            Optional.ofNullable(this.builder.getWebhookUrl()).filter(webhookUrl -> !webhookUrl.isEmpty()).ifPresent(webhookUrl -> this.sendWebhookNotificationTeams(this.master.getId(), this.build.getCurrentTest().getName(), this.build.getPublicReport(), (String)webhookUrl));
                        }
                        break block15;
                    }
                    this.listener.error(BzmJobNotifier.formatMessage("Failed to start test"));
                    Result runId = this.isUnstableIfHasFails ? Result.UNSTABLE : Result.FAILURE;
                    return runId;
                }
                catch (InterruptedException e) {
                    EnvVars.masterEnvVars.put("isInterrupted-" + this.jobName + "-" + this.buildId, "false");
                    utils.getLogger().warn("Wait for finish has been interrupted", (Throwable)e);
                    this.interrupt(this.build, this.master, logger);
                    EnvVars.masterEnvVars.put("isInterrupted-" + this.jobName + "-" + this.buildId, "true");
                    Result result = Result.ABORTED;
                    return result;
                }
                catch (Exception e) {
                    if (this.master == null) {
                        utils.getLogger().warn("Failed to start BlazeMeter test", (Throwable)e);
                        logger.println(BzmJobNotifier.formatMessage("Failed to start BlazeMeter test: " + e.getMessage()));
                    } else {
                        utils.getLogger().warn("Caught exception while waiting for build", (Throwable)e);
                        logger.println(BzmJobNotifier.formatMessage("Caught exception: " + e.getMessage()));
                    }
                    Result result = this.isUnstableIfHasFails ? Result.UNSTABLE : Result.FAILURE;
                    utils.closeLogger();
                    return result;
                }
            }
            BuildResult buildResult = this.build.doPostProcess(this.master);
            Result result = this.mappedBuildResult(buildResult);
            return result;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            utils.closeLogger();
        }
    }

    private void putLinkName(String runId) {
        String linkName = StringUtils.isBlank((String)this.reportLinkName) ? "BlazeMeter report: " + this.build.getCurrentTest().getName() : this.reportLinkName;
        EnvVars.masterEnvVars.put(runId + "-link-name", this.prepareReportLinkName(linkName, this.getReportLinkNameLength()));
    }

    private int getReportLinkNameLength() {
        try {
            String len = (String)this.envVars.get((Object)"bzm.reportLinkName.length");
            if (StringUtils.isBlank((String)len)) {
                LOGGER.fine("Property bzm.reportLinkName.length did not find in Jenkins envVars");
                len = System.getProperty("bzm.reportLinkName.length");
                if (StringUtils.isBlank((String)len)) {
                    LOGGER.fine("Property bzm.reportLinkName.length did not find in System.properties");
                    len = "35";
                }
            }
            LOGGER.info("Get report link name length = " + len);
            return Integer.parseInt(len);
        }
        catch (NumberFormatException ex) {
            LOGGER.warning("Cannot parse report link name length = " + ex.getMessage());
            return 35;
        }
    }

    private String prepareReportLinkName(String name, int lengthLimit) {
        return name.length() > lengthLimit ? name.substring(0, lengthLimit) + ".." : name;
    }

    private Result mappedBuildResult(BuildResult buildResult) {
        switch (buildResult) {
            case SUCCESS: {
                return Result.SUCCESS;
            }
            case ABORTED: {
                return Result.ABORTED;
            }
            case ERROR: {
                return Result.UNSTABLE;
            }
            case FAILED: {
                return Result.FAILURE;
            }
        }
        return Result.NOT_BUILT;
    }

    public void interrupt(CiBuild build, Master master, PrintStream logger) {
        if (build != null && master != null) {
            try {
                boolean hasReport = build.interrupt(master);
                if (hasReport) {
                    logger.println(BzmJobNotifier.formatMessage("Get reports after interrupt"));
                    build.doPostProcess(master);
                }
            }
            catch (IOException e) {
                logger.println(BzmJobNotifier.formatMessage("Failed to interrupt build " + e.getMessage()));
            }
        }
    }

    private String createLogFile(FilePath workspace) throws IOException, InterruptedException {
        FilePath logFile = workspace.child("bzm-log-" + System.currentTimeMillis());
        logFile.touch(System.currentTimeMillis());
        return logFile.getRemote();
    }

    private FilePath createWorkspaceDir(FilePath workspace) throws IOException, InterruptedException {
        FilePath wsp = new FilePath(workspace.getChannel(), workspace.getRemote() + File.separator + this.buildId);
        wsp.mkdirs();
        return wsp;
    }

    private JenkinsBlazeMeterUtils createBzmUtils() {
        return new JenkinsBlazeMeterUtils(this.apiId, this.apiSecret, this.serverURL, new BzmJobNotifier(this.listener), new BzmServerLogger());
    }

    private CiBuild createCiBuild(JenkinsBlazeMeterUtils utils, FilePath workspace) {
        return new CiBuild((BlazeMeterUtils)utils, Utils.getTestId(this.builder.getTestId()), this.getMainTestFile(workspace), this.getAdditionalTestFiles(workspace), this.envVars.expand(this.builder.getSessionProperties()), this.envVars.expand(this.builder.getNotes()), this.createCiPostProcess(utils, workspace));
    }

    private List<File> getAdditionalTestFiles(FilePath workspace) {
        String additionalFiles = this.envVars.expand(this.additionalTestFiles);
        if (StringUtils.isBlank((String)additionalFiles)) {
            return null;
        }
        String[] paths = additionalFiles.split("\\n");
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (!StringUtils.isNotBlank((String)path)) continue;
            FilePath child = workspace.child(path);
            String remote = child.getRemote();
            File file = new File(remote);
            if (file.exists()) {
                result.add(file);
                continue;
            }
            this.listener.error("Additional test file does not exist: " + remote);
            throw new RuntimeException("Additional test file does not exist: " + remote);
        }
        return result;
    }

    private File getMainTestFile(FilePath workspace) {
        String path = this.envVars.expand(this.mainTestFile);
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        FilePath child = workspace.child(path);
        String remote = child.getRemote();
        File file = new File(remote);
        if (!file.exists()) {
            this.listener.error("Main test file does not exist: " + remote);
            throw new RuntimeException("Main test file does not exist: " + remote);
        }
        return file;
    }

    private CiPostProcess createCiPostProcess(JenkinsBlazeMeterUtils utils, FilePath workspace) {
        return new CiPostProcess(this.builder.isGetJtl(), this.builder.isGetJunit(), this.envVars.expand(this.builder.getJtlPath()), this.envVars.expand(this.builder.getJunitPath()), workspace.getRemote(), utils){

            public boolean isErrorsFailed(JSONArray errors) {
                if (BzmBuild.this.isUnstableIfHasFails) {
                    return false;
                }
                return super.isErrorsFailed(errors);
            }
        };
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }

    public CiBuild getBuild() {
        return this.build;
    }

    public void createGlobalEnvironmentVariables(String key, String value) {
        PrintStream logger = this.listener.getLogger();
        try {
            Jenkins instance = Jenkins.getInstance();
            DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
            List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
            EnvironmentVariablesNodeProperty newEnvVarsNodeProperty = null;
            EnvVars envVars = null;
            if (envVarsNodePropertyList == null || envVarsNodePropertyList.size() == 0) {
                newEnvVarsNodeProperty = new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[0]);
                globalNodeProperties.add((Object)newEnvVarsNodeProperty);
                envVars = newEnvVarsNodeProperty.getEnvVars();
            } else {
                envVars = ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
            }
            envVars.put(key, value);
            instance.save();
        }
        catch (Exception e) {
            logger.println(BzmJobNotifier.formatMessage("Error generated by creating global env"));
        }
    }

    private String getColor(BuildResult buildResult) {
        return buildResult == BuildResult.FAILED ? "#FF0000" : "#008000";
    }

    public void sendWebhookNotificationTeams(String masterId, String testName, String publicReportUrl, String webhookUrl) {
        BuildResult buildResult = this.build.doPostProcess(this.master);
        String color = this.getColor(buildResult);
        String json = "{\n    \"@type\": \"MessageCard\",\n    \"@context\": \"http://schema.org/extensions\",\n    \"themeColor\": \"" + color + "\",\n    \"summary\": \"Blazemeter Test Execution\",\n    \"sections\": [\n        {\n            \"activityTitle\": \"Blazemeter Test Execution\",\n            \"facts\": [\n                {\n                    \"name\": \"Test Name : \",\n                    \"value\": \"" + testName + "\"\n                },\n                {\n                    \"name\": \"Master ID : \",\n                    \"value\": \"" + masterId + "\"\n                },\n                {\n                    \"name\": \"Test Status : \",\n                    \"value\": \"" + buildResult + "\"\n                }\n            ],\n            \"markdown\": true\n        }\n    ],\n    \"potentialAction\": [\n        {\n            \"@type\": \"OpenUri\",\n            \"name\": \"View Report\",\n            \"targets\": [\n                {\n                    \"os\": \"default\",\n                    \"uri\": \"" + publicReportUrl + "\"\n                }\n            ]\n        }\n    ]\n}\n";
        this.sendWebhookNotification(webhookUrl, json);
    }

    public void sendWebhookNotificationSlack(String masterId, String testName, String publicReportUrl, String webhookUrl) {
        BuildResult buildResult = this.build.doPostProcess(this.master);
        String color = this.getColor(buildResult);
        String jsonPayload = String.format("{\"attachments\":[{\"title\":\"Blazemeter Test Execution\",\"pretext\":\"Blazemeter Test Execution\",\"fallback\":\"Blazemeter Test Execution\",\"color\":\"%s\",\"fields\":[{\"title\":\"Test Name\",\"value\":\"%s\",\"short\":true},{\"title\":\"Master ID\",\"value\":\"%s\",\"short\":true},{\"title\":\"Test Status\",\"value\":\"%s\",\"short\":true},{\"title\":\"View Report\",\"value\":\"%s\",\"short\":true}]}]}", color, testName, masterId, buildResult, publicReportUrl);
        this.sendWebhookNotification(webhookUrl, jsonPayload);
    }

    private void sendWebhookNotification(String webhookUrl, String jsonPayload) {
        PrintStream logger = this.listener.getLogger();
        try {
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            byte[] postData = jsonPayload.getBytes(StandardCharsets.UTF_8);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(postData);
            int responseCode = connection.getResponseCode();
            logger.println(BzmJobNotifier.formatMessage("Response Code: " + responseCode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

