/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils.notifier;

import com.blazemeter.api.logging.UserNotifier;
import hudson.model.TaskListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class BzmJobNotifier
implements UserNotifier {
    private final TaskListener listener;
    private static final String PATTERN_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public BzmJobNotifier(TaskListener listener) {
        this.listener = listener;
    }

    public static String formatMessage(String msg) {
        Instant date = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN_FORMAT).withZone(ZoneId.systemDefault());
        String formattedInstant = formatter.format(date);
        return "[" + formattedInstant + "]: " + msg;
    }

    public void notifyInfo(String s) {
        this.listener.getLogger().println(BzmJobNotifier.formatMessage(s));
    }

    public void notifyWarning(String s) {
        this.listener.getLogger().println(BzmJobNotifier.formatMessage("WARN: " + s));
    }

    public void notifyError(String s) {
        this.listener.error(BzmJobNotifier.formatMessage(s));
    }
}

