/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.Item;
import hudson.plugins.blazemeter.BlazemeterCredentialsBAImpl;
import hudson.security.ACL;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.acegisecurity.Authentication;

public class Utils {
    private Utils() {
    }

    public static String getTestId(String testId) {
        try {
            return testId.substring(testId.lastIndexOf("(") + 1, testId.lastIndexOf("."));
        }
        catch (Exception e) {
            return testId;
        }
    }

    public static List<BlazemeterCredentialsBAImpl> getCredentials(Object scope) {
        ArrayList<BlazemeterCredentialsBAImpl> result = new ArrayList<BlazemeterCredentialsBAImpl>();
        HashSet<String> apiKeys = new HashSet<String>();
        Item item = scope instanceof Item ? (Item)scope : null;
        for (BlazemeterCredentialsBAImpl c : CredentialsProvider.lookupCredentials(BlazemeterCredentialsBAImpl.class, (Item)item, (Authentication)ACL.SYSTEM)) {
            String id = c.getId();
            if (apiKeys.contains(id)) continue;
            result.add(c);
            apiKeys.add(id);
        }
        return result;
    }

    public static BlazemeterCredentialsBAImpl findCredentials(String credentialsId, Object scope) {
        List<BlazemeterCredentialsBAImpl> creds = Utils.getCredentials(scope);
        BlazemeterCredentialsBAImpl cred = BlazemeterCredentialsBAImpl.EMPTY;
        for (BlazemeterCredentialsBAImpl c : creds) {
            if (!c.getId().equals(credentialsId)) continue;
            cred = c;
        }
        return cred;
    }

    public static String version() {
        Properties props = new Properties();
        ClassLoader classLoader = Utils.class.getClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream("version.properties");
        if (resourceAsStream != null) {
            try {
                props.load(resourceAsStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return props.getProperty("version");
    }

    public static String resolveTestId(String savedTestId) {
        try {
            int startIndex = savedTestId.lastIndexOf("(") + 1;
            int endIndex = savedTestId.lastIndexOf(")");
            return savedTestId.substring(startIndex, endIndex);
        }
        catch (Exception e) {
            return savedTestId;
        }
    }
}

