// CHECKSTYLE:OFF

package hudson.plugins.blazemeter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildAction.DisplayName}: {@code BlazeMeter Report}.
     * 
     * @return
     *     {@code BlazeMeter Report}
     */
    public static String BuildAction_DisplayName() {
        return holder.format("BuildAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.DisplayName}: {@code BlazeMeter Report}.
     * 
     * @return
     *     {@code BlazeMeter Report}
     */
    public static Localizable _BuildAction_DisplayName() {
        return new Localizable(holder, "BuildAction.DisplayName");
    }

    /**
     * Key {@code Publisher.DisplayName}: {@code BlazeMeter Testings - JMeter
     * in the cloud}.
     * 
     * @return
     *     {@code BlazeMeter Testings - JMeter in the cloud}
     */
    public static String Publisher_DisplayName() {
        return holder.format("Publisher.DisplayName");
    }

    /**
     * Key {@code Publisher.DisplayName}: {@code BlazeMeter Testings - JMeter
     * in the cloud}.
     * 
     * @return
     *     {@code BlazeMeter Testings - JMeter in the cloud}
     */
    public static Localizable _Publisher_DisplayName() {
        return new Localizable(holder, "Publisher.DisplayName");
    }

    /**
     * Key {@code Report.DisplayName}: {@code BlazeMeter}.
     * 
     * @return
     *     {@code BlazeMeter}
     */
    public static String Report_DisplayName() {
        return holder.format("Report.DisplayName");
    }

    /**
     * Key {@code Report.DisplayName}: {@code BlazeMeter}.
     * 
     * @return
     *     {@code BlazeMeter}
     */
    public static Localizable _Report_DisplayName() {
        return new Localizable(holder, "Report.DisplayName");
    }

    /**
     * Key {@code ProjectAction.Minimum}: {@code min}.
     * 
     * @return
     *     {@code min}
     */
    public static String ProjectAction_Minimum() {
        return holder.format("ProjectAction.Minimum");
    }

    /**
     * Key {@code ProjectAction.Minimum}: {@code min}.
     * 
     * @return
     *     {@code min}
     */
    public static Localizable _ProjectAction_Minimum() {
        return new Localizable(holder, "ProjectAction.Minimum");
    }

    /**
     * Key {@code BlazemeterLegacyCredential.DisplayName}: {@code BlazeMeter
     * Legacy Credentials(DEPRECATED)}.
     * 
     * @return
     *     {@code BlazeMeter Legacy Credentials(DEPRECATED)}
     */
    public static String BlazemeterLegacyCredential_DisplayName() {
        return holder.format("BlazemeterLegacyCredential.DisplayName");
    }

    /**
     * Key {@code BlazemeterLegacyCredential.DisplayName}: {@code BlazeMeter
     * Legacy Credentials(DEPRECATED)}.
     * 
     * @return
     *     {@code BlazeMeter Legacy Credentials(DEPRECATED)}
     */
    public static Localizable _BlazemeterLegacyCredential_DisplayName() {
        return new Localizable(holder, "BlazemeterLegacyCredential.DisplayName");
    }

    /**
     * Key {@code ProjectAction.Errors}: {@code errors}.
     * 
     * @return
     *     {@code errors}
     */
    public static String ProjectAction_Errors() {
        return holder.format("ProjectAction.Errors");
    }

    /**
     * Key {@code ProjectAction.Errors}: {@code errors}.
     * 
     * @return
     *     {@code errors}
     */
    public static Localizable _ProjectAction_Errors() {
        return new Localizable(holder, "ProjectAction.Errors");
    }

    /**
     * Key {@code GraphConfigurationDetail.DisplayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static String GraphConfigurationDetail_DisplayName() {
        return holder.format("GraphConfigurationDetail.DisplayName");
    }

    /**
     * Key {@code GraphConfigurationDetail.DisplayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static Localizable _GraphConfigurationDetail_DisplayName() {
        return new Localizable(holder, "GraphConfigurationDetail.DisplayName");
    }

    /**
     * Key {@code ProjectAction.Average}: {@code average}.
     * 
     * @return
     *     {@code average}
     */
    public static String ProjectAction_Average() {
        return holder.format("ProjectAction.Average");
    }

    /**
     * Key {@code ProjectAction.Average}: {@code average}.
     * 
     * @return
     *     {@code average}
     */
    public static Localizable _ProjectAction_Average() {
        return new Localizable(holder, "ProjectAction.Average");
    }

    /**
     * Key {@code ProjectAction.Maximum}: {@code max}.
     * 
     * @return
     *     {@code max}
     */
    public static String ProjectAction_Maximum() {
        return holder.format("ProjectAction.Maximum");
    }

    /**
     * Key {@code ProjectAction.Maximum}: {@code max}.
     * 
     * @return
     *     {@code max}
     */
    public static Localizable _ProjectAction_Maximum() {
        return new Localizable(holder, "ProjectAction.Maximum");
    }

    /**
     * Key {@code TrendReportDetail.DisplayName}: {@code BlazeMeter report}.
     * 
     * @return
     *     {@code BlazeMeter report}
     */
    public static String TrendReportDetail_DisplayName() {
        return holder.format("TrendReportDetail.DisplayName");
    }

    /**
     * Key {@code TrendReportDetail.DisplayName}: {@code BlazeMeter report}.
     * 
     * @return
     *     {@code BlazeMeter report}
     */
    public static Localizable _TrendReportDetail_DisplayName() {
        return new Localizable(holder, "TrendReportDetail.DisplayName");
    }

    /**
     * Key {@code BlazemeterCredential.DisplayName}: {@code BlazeMeter
     * Credentials}.
     * 
     * @return
     *     {@code BlazeMeter Credentials}
     */
    public static String BlazemeterCredential_DisplayName() {
        return holder.format("BlazemeterCredential.DisplayName");
    }

    /**
     * Key {@code BlazemeterCredential.DisplayName}: {@code BlazeMeter
     * Credentials}.
     * 
     * @return
     *     {@code BlazeMeter Credentials}
     */
    public static Localizable _BlazemeterCredential_DisplayName() {
        return new Localizable(holder, "BlazemeterCredential.DisplayName");
    }

    /**
     * Key {@code ProjectAction.Line90}: {@code 90% line}.
     * 
     * @return
     *     {@code 90% line}
     */
    public static String ProjectAction_Line90() {
        return holder.format("ProjectAction.Line90");
    }

    /**
     * Key {@code ProjectAction.Line90}: {@code 90% line}.
     * 
     * @return
     *     {@code 90% line}
     */
    public static Localizable _ProjectAction_Line90() {
        return new Localizable(holder, "ProjectAction.Line90");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code BlazeMeter Trend}.
     * 
     * @return
     *     {@code BlazeMeter Trend}
     */
    public static String ProjectAction_DisplayName() {
        return holder.format("ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code BlazeMeter Trend}.
     * 
     * @return
     *     {@code BlazeMeter Trend}
     */
    public static Localizable _ProjectAction_DisplayName() {
        return new Localizable(holder, "ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.PercentageOfErrors}: {@code Percentage of
     * errors}.
     * 
     * @return
     *     {@code Percentage of errors}
     */
    public static String ProjectAction_PercentageOfErrors() {
        return holder.format("ProjectAction.PercentageOfErrors");
    }

    /**
     * Key {@code ProjectAction.PercentageOfErrors}: {@code Percentage of
     * errors}.
     * 
     * @return
     *     {@code Percentage of errors}
     */
    public static Localizable _ProjectAction_PercentageOfErrors() {
        return new Localizable(holder, "ProjectAction.PercentageOfErrors");
    }

    /**
     * Key {@code ProjectAction.Median}: {@code median}.
     * 
     * @return
     *     {@code median}
     */
    public static String ProjectAction_Median() {
        return holder.format("ProjectAction.Median");
    }

    /**
     * Key {@code ProjectAction.Median}: {@code median}.
     * 
     * @return
     *     {@code median}
     */
    public static Localizable _ProjectAction_Median() {
        return new Localizable(holder, "ProjectAction.Median");
    }

    /**
     * Key {@code ProjectAction.RespondingTime}: {@code Responding time}.
     * 
     * @return
     *     {@code Responding time}
     */
    public static String ProjectAction_RespondingTime() {
        return holder.format("ProjectAction.RespondingTime");
    }

    /**
     * Key {@code ProjectAction.RespondingTime}: {@code Responding time}.
     * 
     * @return
     *     {@code Responding time}
     */
    public static Localizable _ProjectAction_RespondingTime() {
        return new Localizable(holder, "ProjectAction.RespondingTime");
    }

}
