/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.BlazemeterCredentials;
import hudson.plugins.blazemeter.BlazemeterCredentialsBAImpl;
import hudson.plugins.blazemeter.BzmBuild;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.plugins.blazemeter.utils.interrupt.InterruptListenerTask;
import hudson.plugins.blazemeter.utils.notifier.BzmJobNotifier;
import hudson.plugins.blazemeter.utils.report.ReportUrlTask;
import hudson.remoting.Callable;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class PerformanceBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(PerformanceBuilder.class.getName());
    @Deprecated
    private String jobApiKey = "";
    private String credentialsId = "";
    private String workspaceId = "";
    @Deprecated
    private String serverUrl = "";
    private String testId = "";
    private String notes = "";
    private String sessionProperties = "";
    private String jtlPath = "";
    private String junitPath = "";
    private boolean getJtl = false;
    private boolean getJunit = false;
    private String reportLinkName = "";

    @DataBoundConstructor
    public PerformanceBuilder(String credentialsId, String workspaceId, String testId) {
        this.credentialsId = credentialsId;
        this.workspaceId = workspaceId;
        this.testId = testId;
    }

    @Restricted(value={NoExternalUse.class})
    public PerformanceBuilder(String credentialsId, String workspaceId, String serverUrl, String testId, String notes, String sessionProperties, String jtlPath, String junitPath, boolean getJtl, boolean getJunit) {
        this.credentialsId = credentialsId;
        this.workspaceId = workspaceId;
        this.serverUrl = serverUrl;
        this.testId = testId;
        this.jtlPath = jtlPath;
        this.junitPath = junitPath;
        this.getJtl = getJtl;
        this.getJunit = getJunit;
        this.notes = notes;
        this.sessionProperties = sessionProperties;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getTestId() {
        return this.testId;
    }

    @DataBoundSetter
    public void setTestId(String testId) {
        this.testId = testId;
    }

    public boolean isGetJtl() {
        return this.getJtl;
    }

    public boolean isGetJunit() {
        return this.getJunit;
    }

    public String getNotes() {
        return this.notes;
    }

    @DataBoundSetter
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getSessionProperties() {
        return this.sessionProperties;
    }

    public String getJtlPath() {
        return this.jtlPath;
    }

    @DataBoundSetter
    public void setJtlPath(String jtlPath) {
        this.jtlPath = jtlPath;
    }

    public String getJunitPath() {
        return this.junitPath;
    }

    @DataBoundSetter
    public void setJunitPath(String junitPath) {
        this.junitPath = junitPath;
    }

    @DataBoundSetter
    public void setSessionProperties(String sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    @Deprecated
    public String getJobApiKey() {
        return this.jobApiKey;
    }

    @Deprecated
    @DataBoundSetter
    public void setJobApiKey(String jobApiKey) {
        this.jobApiKey = jobApiKey;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @DataBoundSetter
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    @Deprecated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Deprecated
    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @DataBoundSetter
    public void setGetJtl(boolean getJtl) {
        this.getJtl = getJtl;
    }

    @DataBoundSetter
    public void setGetJunit(boolean getJunit) {
        this.getJunit = getJunit;
    }

    public String getReportLinkName() {
        return this.reportLinkName;
    }

    @DataBoundSetter
    public void setReportLinkName(String reportLinkName) {
        this.reportLinkName = reportLinkName;
    }

    private boolean validateTestId(TaskListener listener) {
        if (StringUtils.isBlank((CharSequence)this.testId)) {
            listener.error(BzmJobNotifier.formatMessage("Please, reconfigure job and select valid credentials and test"));
            listener.error(BzmJobNotifier.formatMessage("Refer to https://guide.blazemeter.com/hc/en-us/articles/115002213289-BlazeMeter-API-keys- for getting new credentials."));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        boolean isValidCredentials;
        if (!this.validateTestId(listener)) {
            run.setResult(Result.FAILURE);
            return;
        }
        BlazemeterCredentialsBAImpl credentials = Utils.findCredentials(this.credentialsId, CredentialsScope.GLOBAL);
        boolean bl = isValidCredentials = !StringUtils.isBlank((CharSequence)this.credentialsId) && this.validateCredentials(credentials);
        if (!isValidCredentials) {
            listener.error(BzmJobNotifier.formatMessage("Can not start build: Invalid credentials=" + this.credentialsId + "... is deprecated or absent in credentials store."));
            run.setResult(Result.NOT_BUILT);
            return;
        }
        String serverUrlConfig = BlazeMeterPerformanceBuilderDescriptor.getDescriptor().getBlazeMeterURL();
        String jobName = run.getFullDisplayName();
        VirtualChannel channel = launcher.getChannel();
        long reportLinkId = System.currentTimeMillis();
        EnvVars envVars = run.getEnvironment(listener);
        BzmBuild bzmBuild = new BzmBuild(this, credentials.getUsername(), credentials.getPassword().getPlainText(), jobName, run.getId(), StringUtils.isBlank((CharSequence)serverUrlConfig) ? "https://a.blazemeter.com" : serverUrlConfig, envVars, workspace, listener, ProxyConfiguration.load(), !(channel instanceof LocalChannel), envVars.expand(this.reportLinkName), reportLinkId);
        ReportUrlTask reportUrlTask = new ReportUrlTask(run, jobName, channel, reportLinkId);
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)reportUrlTask, 20000L, 10000L);
        try {
            Result result = (Result)channel.call((Callable)bzmBuild);
            run.setResult(result);
        }
        catch (InterruptedException e) {
            LOGGER.warning("Build has been aborted");
            InterruptListenerTask interrupt = new InterruptListenerTask(run, jobName, channel);
            interrupt.start();
            interrupt.join();
            run.setResult(Result.ABORTED);
        }
        catch (Exception e) {
            listener.getLogger().println(BzmJobNotifier.formatMessage("Failure with exception: " + e.getMessage()));
            e.printStackTrace(listener.getLogger());
            run.setResult(Result.FAILURE);
        }
        finally {
            reportUrlTask.cancel();
            timer.cancel();
            timer.purge();
        }
    }

    private boolean validateCredentials(BlazemeterCredentials credential) {
        return !StringUtils.isBlank((CharSequence)credential.getId()) && credential instanceof BlazemeterCredentialsBAImpl;
    }

    public Object readResolve() {
        if (!StringUtils.isBlank((CharSequence)this.testId) && this.testId.contains("(")) {
            this.testId = Utils.resolveTestId(this.testId);
        }
        return this;
    }

    public static final class DescriptorImpl
    extends BlazeMeterPerformanceBuilderDescriptor {
        @Override
        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return super.configure(req, formData);
        }
    }
}

