/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.blazemeter.api.explorer.Master;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.blazemeter.ciworkflow.BuildResult;
import com.blazemeter.ciworkflow.CiBuild;
import com.blazemeter.ciworkflow.CiPostProcess;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.ProxyConfigurator;
import hudson.plugins.blazemeter.utils.JenkinsBlazeMeterUtils;
import hudson.plugins.blazemeter.utils.JenkinsCiBuild;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.plugins.blazemeter.utils.logger.BzmJobLogger;
import hudson.plugins.blazemeter.utils.notifier.BzmJobNotifier;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

public class BzmBuild
implements Callable<Result, Exception> {
    private static final Logger LOGGER = Logger.getLogger(BzmBuild.class.getName());
    private PerformanceBuilder builder;
    private String jobName;
    private String buildId;
    private String apiId;
    private String apiSecret;
    private String serverURL;
    private EnvVars envVars;
    private FilePath workspace;
    private TaskListener listener;
    private Master master;
    private JenkinsCiBuild build;
    private boolean isSlave;
    private ProxyConfiguration proxyConfiguration;
    private long reportLinkId;
    private String reportLinkName;

    public BzmBuild(PerformanceBuilder builder, String apiId, String apiSecret, String jobName, String buildId, String serverURL, EnvVars envVars, FilePath workspace, TaskListener listener, ProxyConfiguration proxyConfiguration, boolean isSlave, String reportLinkName, long reportLinkId) {
        this.builder = builder;
        this.apiId = apiId;
        this.apiSecret = apiSecret;
        this.jobName = jobName;
        this.buildId = buildId;
        this.serverURL = serverURL;
        this.envVars = envVars;
        this.workspace = workspace;
        this.listener = listener;
        this.proxyConfiguration = proxyConfiguration;
        this.isSlave = isSlave;
        this.reportLinkName = reportLinkName;
        this.reportLinkId = reportLinkId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result call() throws Exception {
        ProxyConfigurator.updateProxySettings(this.proxyConfiguration, this.isSlave);
        PrintStream logger = this.listener.getLogger();
        FilePath wsp = this.createWorkspaceDir(this.workspace);
        logger.println(BzmJobNotifier.formatMessage("BlazemeterJenkins plugin v." + Utils.version()));
        JenkinsBlazeMeterUtils utils = this.createBzmUtils(this.createLogFile(wsp));
        try {
            this.build = this.createCiBuild(utils, wsp);
            try {
                this.master = this.build.start();
                if (this.master == null) {
                    this.listener.error(BzmJobNotifier.formatMessage("Failed to start test"));
                    Result runId = Result.FAILURE;
                    return runId;
                }
                String runId = this.jobName + "-" + this.buildId + "-" + this.reportLinkId;
                EnvVars.masterEnvVars.put(runId, this.master.getId());
                EnvVars.masterEnvVars.put(runId + "-" + this.master.getId(), this.build.getPublicReport());
                this.putLinkName(runId);
                this.build.waitForFinish(this.master);
            }
            catch (InterruptedException e) {
                EnvVars.masterEnvVars.put("isInterrupted-" + this.jobName + "-" + this.buildId, "false");
                utils.getLogger().warn("Wait for finish has been interrupted", (Throwable)e);
                this.interrupt(this.build, this.master, logger);
                EnvVars.masterEnvVars.put("isInterrupted-" + this.jobName + "-" + this.buildId, "true");
                Result result = Result.ABORTED;
                return result;
            }
            catch (Exception e) {
                utils.getLogger().warn("Caught exception while waiting for build", (Throwable)e);
                logger.println(BzmJobNotifier.formatMessage("Caught exception " + e.getMessage()));
                Result result = Result.FAILURE;
                utils.closeLogger();
                return result;
            }
            BuildResult buildResult = this.build.doPostProcess(this.master);
            Result result = this.mappedBuildResult(buildResult);
            return result;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            utils.closeLogger();
        }
    }

    private void putLinkName(String runId) {
        String linkName = StringUtils.isBlank((String)this.reportLinkName) ? "BlazeMeter report: " + this.build.getCurrentTest().getName() : this.reportLinkName;
        EnvVars.masterEnvVars.put(runId + "-link-name", this.prepareReportLinkName(linkName, this.getReportLinkNameLength()));
    }

    private int getReportLinkNameLength() {
        try {
            String len = (String)this.envVars.get((Object)"bzm.reportLinkName.length");
            if (StringUtils.isBlank((String)len)) {
                LOGGER.fine("Property bzm.reportLinkName.length did not find in Jenkins envVars");
                len = System.getProperty("bzm.reportLinkName.length");
                if (StringUtils.isBlank((String)len)) {
                    LOGGER.fine("Property bzm.reportLinkName.length did not find in System.properties");
                    len = "35";
                }
            }
            LOGGER.info("Get report link name length = " + len);
            return Integer.parseInt(len);
        }
        catch (NumberFormatException ex) {
            LOGGER.warning("Cannot parse report link name length = " + ex.getMessage());
            return 35;
        }
    }

    private String prepareReportLinkName(String name, int lengthLimit) {
        return name.length() > lengthLimit ? name.substring(0, lengthLimit) + ".." : name;
    }

    private Result mappedBuildResult(BuildResult buildResult) {
        switch (buildResult) {
            case SUCCESS: {
                return Result.SUCCESS;
            }
            case ABORTED: {
                return Result.ABORTED;
            }
            case ERROR: {
                return Result.UNSTABLE;
            }
            case FAILED: {
                return Result.FAILURE;
            }
        }
        return Result.NOT_BUILT;
    }

    public void interrupt(CiBuild build, Master master, PrintStream logger) {
        if (build != null && master != null) {
            try {
                boolean hasReport = build.interrupt(master);
                if (hasReport) {
                    logger.println(BzmJobNotifier.formatMessage("Get reports after interrupt"));
                    build.doPostProcess(master);
                }
            }
            catch (IOException e) {
                logger.println(BzmJobNotifier.formatMessage("Failed to interrupt build " + e.getMessage()));
            }
        }
    }

    private String createLogFile(FilePath workspace) throws IOException, InterruptedException {
        FilePath logFile = workspace.child("bzm-log-" + System.currentTimeMillis());
        logFile.touch(System.currentTimeMillis());
        return logFile.getRemote();
    }

    private FilePath createWorkspaceDir(FilePath workspace) throws IOException, InterruptedException {
        FilePath wsp = new FilePath(workspace.getChannel(), workspace.getRemote() + File.separator + this.buildId);
        wsp.mkdirs();
        return wsp;
    }

    private JenkinsBlazeMeterUtils createBzmUtils(String logFile) {
        return new JenkinsBlazeMeterUtils(this.apiId, this.apiSecret, this.serverURL, new BzmJobNotifier(this.listener), new BzmJobLogger(logFile));
    }

    private JenkinsCiBuild createCiBuild(JenkinsBlazeMeterUtils utils, FilePath workspace) {
        return new JenkinsCiBuild(utils, Utils.getTestId(this.builder.getTestId()), this.envVars.expand(this.builder.getSessionProperties()), this.envVars.expand(this.builder.getNotes()), this.createCiPostProcess(utils, workspace));
    }

    private CiPostProcess createCiPostProcess(JenkinsBlazeMeterUtils utils, FilePath workspace) {
        return new CiPostProcess(this.builder.isGetJtl(), this.builder.isGetJunit(), this.envVars.expand(this.builder.getJtlPath()), this.envVars.expand(this.builder.getJunitPath()), workspace.getRemote(), (BlazeMeterUtils)utils);
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }

    public CiBuild getBuild() {
        return this.build;
    }
}

