/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.blazemeter.api.explorer.User;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.BlazemeterCredentials;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.utils.JenkinsBlazeMeterUtils;
import hudson.util.FormValidation;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import javax.validation.constraints.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BlazemeterCredentialsBAImpl
extends BaseStandardCredentials
implements BlazemeterCredentials,
StandardUsernamePasswordCredentials {
    public static BlazemeterCredentialsBAImpl EMPTY = new BlazemeterCredentialsBAImpl(CredentialsScope.GLOBAL, "", "", "", "");
    @NotNull
    private final String username;
    @NotNull
    private final Secret password;

    @DataBoundConstructor
    public BlazemeterCredentialsBAImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String username, @CheckForNull String password) {
        super(scope, id, description);
        this.username = Util.fixNull((String)username);
        this.password = Secret.fromString((String)password);
    }

    @NotNull
    public Secret getPassword() {
        return this.password;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.BlazemeterCredential_DisplayName();
        }

        public String getIconClassName() {
            return "icon-credentials-userpass";
        }

        public FormValidation doValidate(@QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            String decryptedPassword = Secret.fromString((String)password).getPlainText();
            try {
                JenkinsBlazeMeterUtils utils = BlazeMeterPerformanceBuilderDescriptor.getBzmUtils(username, decryptedPassword);
                User.getUser((BlazeMeterUtils)utils);
                return FormValidation.ok((String)"Successfully validated credentials.");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

