/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils.report;

import hudson.plugins.blazemeter.utils.report.LoggerTask;
import hudson.plugins.blazemeter.utils.report.ReportUrlTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BuildReporter {
    private static int LOG_INTERVAL = 10;
    private final ScheduledExecutorService exec = Executors.newScheduledThreadPool(100);
    private ScheduledFuture<?> urlTask;
    private ScheduledFuture<?> logTask;

    public void run(ReportUrlTask g, LoggerTask l) {
        if (this.urlTask == null || this.urlTask.isDone()) {
            this.urlTask = this.exec.scheduleAtFixedRate(g, 120L, 120L, TimeUnit.SECONDS);
        }
        if (this.logTask == null || this.logTask.isDone()) {
            this.logTask = this.exec.scheduleAtFixedRate(l, 5L, LOG_INTERVAL, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.urlTask != null || !this.urlTask.isDone()) {
            this.urlTask.cancel(false);
        }
        if (this.logTask != null || !this.logTask.isDone()) {
            try {
                Thread.sleep(LOG_INTERVAL * 4 * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.logTask.cancel(false);
            }
        }
    }
}

