/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.testresult;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class TestResult {
    protected double std;
    protected double average;
    protected double min;
    protected double max;
    protected double samples;
    protected double median;
    protected double percentile90;
    protected double percentile99;
    protected double errorPercentage;
    protected double hits;
    protected double kbs;
    protected long n;

    public TestResult(JSONObject json) throws IOException, JSONException {
        this.std = json.getDouble("std");
        this.average = json.getDouble("avg");
        this.min = json.getDouble("min");
        this.max = json.getDouble("max");
        this.samples = -1.0;
        this.median = -1.0;
        this.percentile90 = json.getDouble("tp90");
        this.errorPercentage = json.getDouble("failed") / json.getDouble("hits") * 100.0;
        this.hits = json.getDouble("hits");
        this.kbs = json.getDouble("bytes") / 1024.0;
        this.n = -1L;
    }

    public String toString() {
        String hits = String.valueOf(this.hits);
        String errorPercentage = String.valueOf(this.errorPercentage);
        String average = String.valueOf(this.average);
        String min = String.valueOf(this.min);
        String max = String.valueOf(this.max);
        return "AggregateTestResult -> hits=" + hits + ", errors percentage=" + errorPercentage + ", average=" + average + ", min=" + min + ", max=" + max;
    }

    public double getStd() {
        return this.std;
    }

    public void setStd(double std) {
        this.std = std;
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getSamples() {
        return this.samples;
    }

    public void setSamples(double samples) {
        this.samples = samples;
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public double getPercentile90() {
        return this.percentile90;
    }

    public void setPercentile90(double percentile90) {
        this.percentile90 = percentile90;
    }

    public double getPercentile99() {
        return this.percentile99;
    }

    public void setPercentile99(double percentile99) {
        this.percentile99 = percentile99;
    }

    public double getErrorPercentage() {
        return this.errorPercentage;
    }

    public void setErrorPercentage(double errorPercentage) {
        this.errorPercentage = errorPercentage;
    }

    public double getHits() {
        return this.hits;
    }

    public void setHits(double hits) {
        this.hits = hits;
    }

    public double getKbs() {
        return this.kbs;
    }

    public void setKbs(double kbs) {
        this.kbs = kbs;
    }

    public long getN() {
        return this.n;
    }

    public void setN(long n) {
        this.n = n;
    }
}

