/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.api;

import hudson.ProxyConfiguration;
import hudson.plugins.blazemeter.api.Method;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.util.log.StdErrLog;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    private StdErrLog logger = new StdErrLog("BZM-JEN");
    private transient CloseableHttpClient httpClient = null;
    private HttpHost proxy = null;
    private HashMap<String, String> headers = new HashMap();

    public HttpUtil(ProxyConfiguration proxy) {
        this.headers.put("Accept", "application/json");
        this.headers.put("Content-type", "application/json; charset=UTF-8");
        this.httpClient = HttpClients.createDefault();
        this.logger.setDebugEnabled(false);
        try {
            proxy = proxy == null ? ProxyConfiguration.load() : proxy;
        }
        catch (IOException ie) {
            this.logger.warn("Failed to load jenkins proxy configuration: ", (Throwable)ie);
            proxy = null;
        }
        catch (NullPointerException e) {
            proxy = null;
            this.logger.warn("No proxy configuration: check that jub is run on master node. ", (Throwable)e);
        }
        catch (Exception e) {
            proxy = null;
            this.logger.warn("Failed to load jenkins proxy configuration: ", (Throwable)e);
        }
        if (proxy != null) {
            this.proxy = new HttpHost(proxy.name, proxy.port);
            String proxyUser = proxy.getUserName();
            String proxyPass = proxy.getPassword();
            if (!proxyUser.isEmpty() && !proxyPass.isEmpty()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy.name, proxy.port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
                this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            }
        }
    }

    public <V> HttpResponse responseHTTP(String url, V data, Method method) throws IOException {
        CloseableHttpResponse response;
        block14: {
            if (StringUtils.isBlank((String)url)) {
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Requesting : " + url.substring(0, url.indexOf("?") + 14), new Object[0]);
            }
            response = null;
            HttpGet request = null;
            try {
                switch (method) {
                    case GET: {
                        request = new HttpGet(url);
                        break;
                    }
                    case POST: {
                        request = new HttpPost(url);
                        if (data == null) break;
                        ((HttpPost)request).setEntity((HttpEntity)new StringEntity(data.toString()));
                        break;
                    }
                    case PUT: {
                        request = new HttpPut(url);
                        if (data == null) break;
                        ((HttpPut)request).setEntity((HttpEntity)new StringEntity(data.toString()));
                        break;
                    }
                    case PATCH: {
                        request = new HttpPatch(url);
                        if (data == null) break;
                        ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(data.toString()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported method: " + method.toString());
                    }
                }
                for (String s : this.headers.keySet()) {
                    request.setHeader(s, this.headers.get(s));
                }
                if (this.proxy != null) {
                    RequestConfig conf = RequestConfig.custom().setProxy(this.proxy).build();
                    request.setConfig(conf);
                }
                if ((response = this.httpClient.execute((HttpUriRequest)request)) == null || response.getStatusLine() == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Erroneous response (Probably null) for url: \n", new Object[]{url});
                    }
                    response = null;
                }
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block14;
                this.logger.debug("Problems with creating and sending request: \n", (Throwable)e);
            }
        }
        return response;
    }

    public <T, V> T response(String url, V data, Method method, Class<T> returnType, Class<V> dataType) {
        JSONObject jo;
        Object returnObj;
        block12: {
            returnObj = null;
            jo = null;
            String output = null;
            HttpResponse response = null;
            try {
                response = this.responseHTTP(url, data, method);
                if (response != null) {
                    output = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received object from server: " + output, new Object[0]);
                    }
                }
                if (output.isEmpty()) {
                    throw new IOException();
                }
                jo = new JSONObject(output);
            }
            catch (IOException ioe) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received empty response from server: ", (Throwable)ioe);
                }
                return null;
            }
            catch (JSONException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ERROR decoding Json: ", (Throwable)e);
                }
                returnType = String.class;
                return (T)returnType.cast(output);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block12;
                this.logger.debug("Failed to do request:", (Throwable)e);
            }
        }
        try {
            returnObj = returnType.cast(jo);
        }
        catch (ClassCastException cce) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failed to parse response from server: ", (Throwable)cce);
            }
            throw new RuntimeException(jo.toString());
        }
        return (T)returnObj;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public StdErrLog getLogger() {
        return this.logger;
    }

    public void setLogger(StdErrLog logger) {
        this.logger = logger;
    }
}

