/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.api;

import com.google.common.collect.LinkedHashMultimap;
import hudson.ProxyConfiguration;
import hudson.plugins.blazemeter.api.Api;
import hudson.plugins.blazemeter.api.HttpUtil;
import hudson.plugins.blazemeter.api.Method;
import hudson.plugins.blazemeter.api.TestType;
import hudson.plugins.blazemeter.api.urlmanager.UrlManager;
import hudson.plugins.blazemeter.api.urlmanager.UrlManagerV3Impl;
import hudson.plugins.blazemeter.entities.TestStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.log.StdErrLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiV3Impl
implements Api {
    private StdErrLog logger = new StdErrLog("BZM-JEN");
    private final String apiKey;
    UrlManager urlManager;
    private HttpUtil bzmhc = null;

    public ApiV3Impl(String apiKey, String blazeMeterUrl) {
        this(apiKey, blazeMeterUrl, null);
    }

    public ApiV3Impl(String apiKey, String blazeMeterUrl, ProxyConfiguration proxy) {
        this.apiKey = apiKey;
        this.urlManager = new UrlManagerV3Impl(blazeMeterUrl);
        try {
            this.bzmhc = new HttpUtil(proxy);
        }
        catch (Exception ex) {
            this.logger.warn("ERROR Instantiating HTTPClient. Exception received: ", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTestMasterStatusCode(String id) {
        int statusCode = 0;
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)id)) {
            return statusCode;
        }
        try {
            String url = this.urlManager.masterStatus("jnk100x987c06f4e10c4", this.apiKey, id);
            JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
            JSONObject result = (JSONObject)jo.get("result");
            statusCode = result.getInt("progress");
            return statusCode;
        }
        catch (Exception e) {
            this.logger.warn("Error getting status ", (Throwable)e);
        }
        finally {
            return statusCode;
        }
    }

    @Override
    public TestStatus getTestStatus(String id) {
        TestStatus testStatus = null;
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)id)) {
            testStatus = TestStatus.NotFound;
            return testStatus;
        }
        try {
            String url = this.urlManager.masterStatus("jnk100x987c06f4e10c4", this.apiKey, id);
            JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
            JSONObject result = (JSONObject)jo.get("result");
            if (result.has("dataUrl") && result.get("dataUrl") == null) {
                testStatus = TestStatus.NotFound;
            } else if (result.has("status") && !result.getString("status").equals("ENDED")) {
                testStatus = TestStatus.Running;
            } else if (result.has("errors") && !result.get("errors").equals(JSONObject.NULL)) {
                this.logger.debug("Error received from server: " + result.get("errors").toString(), new Object[0]);
                testStatus = TestStatus.Error;
            } else {
                testStatus = TestStatus.NotRunning;
                this.logger.info("Master with id=" + id + " has status = " + TestStatus.NotRunning.name(), new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error getting status ", (Throwable)e);
            testStatus = TestStatus.Error;
        }
        return testStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String startTest(String testId, TestType testType) throws JSONException {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)testId)) {
            return null;
        }
        String url = "";
        switch (testType) {
            case multi: {
                url = this.urlManager.collectionStart("jnk100x987c06f4e10c4", this.apiKey, testId);
                break;
            }
            default: {
                url = this.urlManager.testStart("jnk100x987c06f4e10c4", this.apiKey, testId);
            }
        }
        JSONObject jo = this.bzmhc.response(url, null, Method.POST, JSONObject.class, null);
        if (jo == null) {
            boolean isActive;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received NULL from server while start operation: will do 5 retries", new Object[0]);
            }
            if (!(isActive = this.active(testId))) {
                int retries = 1;
                while (retries < 6) {
                    try {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Trying to repeat start request: " + retries + " retry.", new Object[0]);
                        }
                        this.logger.debug("Pausing thread for " + 10 * retries + " seconds before doing " + retries + " retry.", new Object[0]);
                        Thread.sleep(10000 * retries);
                        jo = this.bzmhc.response(url, null, Method.POST, JSONObject.class, null);
                        if (jo == null) continue;
                        break;
                    }
                    catch (InterruptedException ie) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Start operation was interrupted at pause during " + retries + " request retry.", new Object[0]);
                    }
                    catch (Exception ex) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Received bad response from server while starting test: " + retries + " retry.", new Object[0]);
                    }
                    finally {
                        ++retries;
                    }
                }
            }
        }
        JSONObject result = null;
        try {
            result = (JSONObject)jo.get("result");
        }
        catch (Exception e) {
            String error = jo.get("error").toString();
            return error;
        }
        return result.getString("id");
    }

    @Override
    public int getTestCount() throws JSONException, IOException, ServletException {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            return 0;
        }
        String url = this.urlManager.tests("jnk100x987c06f4e10c4", this.apiKey);
        try {
            JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
            if (jo == null) {
                return -1;
            }
            JSONArray result = (JSONArray)jo.get("result");
            return result.length();
        }
        catch (JSONException e) {
            this.logger.warn("Error getting response from server: ", (Throwable)e);
            return -1;
        }
        catch (RuntimeException e) {
            this.logger.warn("Error getting response from server: ", (Throwable)e);
            return -1;
        }
    }

    @Override
    public JSONObject stopTest(String testId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)testId)) {
            return null;
        }
        String url = this.urlManager.testStop("jnk100x987c06f4e10c4", this.apiKey, testId);
        JSONObject stopJSON = this.bzmhc.response(url, null, Method.POST, JSONObject.class, null);
        return stopJSON;
    }

    @Override
    public void terminateTest(String testId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)testId)) {
            return;
        }
        String url = this.urlManager.testTerminate("jnk100x987c06f4e10c4", this.apiKey, testId);
        this.bzmhc.response(url, null, Method.POST, JSONObject.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject testReport(String reportId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)reportId)) {
            return null;
        }
        String url = this.urlManager.testReport("jnk100x987c06f4e10c4", this.apiKey, reportId);
        JSONObject summary = null;
        JSONObject result = null;
        try {
            result = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null).getJSONObject("result");
            summary = (JSONObject)result.getJSONArray("summary").get(0);
            return summary;
        }
        catch (JSONException je) {
            this.logger.warn("Aggregate report(result object): " + result, new Object[0]);
            this.logger.warn("Error while parsing aggregate report summary: check common jenkins log and make sure that aggregate reportis valid/not empty.", (Throwable)je);
        }
        catch (Exception e) {
            this.logger.warn("Aggregate report(result object): " + result, new Object[0]);
            this.logger.warn("Error while parsing aggregate report summary: check common jenkins log and make sure that aggregate reportis valid/not empty.", (Throwable)e);
        }
        finally {
            return summary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMultimap<String, String> getTestsMultiMap() throws IOException, MessagingException {
        LinkedHashMultimap testListOrdered = null;
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            return null;
        }
        String url = this.urlManager.tests("jnk100x987c06f4e10c4", this.apiKey);
        this.logger.info("Getting testList with URL=" + url.substring(0, url.indexOf("?") + 14), new Object[0]);
        try {
            block14: {
                JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
                JSONArray result = null;
                if (jo.has("result") && !jo.get("result").equals(JSONObject.NULL)) {
                    result = (JSONArray)jo.get("result");
                }
                if (result == null) break block14;
                if (result.length() <= 0) break;
                testListOrdered = LinkedHashMultimap.create((int)result.length(), (int)result.length());
                for (int i = 0; i < result.length(); ++i) {
                    JSONObject en = null;
                    try {
                        en = result.getJSONObject(i);
                    }
                    catch (JSONException e) {
                        this.logger.warn("Error with the JSON while populating test list, " + (Object)((Object)e), new Object[0]);
                    }
                    try {
                        if (en == null) continue;
                        String id = en.getString("id");
                        String name = en.has("name") ? en.getString("name").replaceAll("&", "&amp;") : "";
                        String testType = en.has("type") ? en.getString("type") : "unknown_type";
                        testListOrdered.put((Object)name, (Object)(id + "." + testType));
                        continue;
                    }
                    catch (JSONException ie) {
                        this.logger.warn("Error with the JSON while populating test list, ", (Throwable)ie);
                    }
                }
                break;
            }
        }
        catch (NullPointerException npe) {
            this.logger.warn("Error while receiving answer from server - check connection/proxy settings ", (Throwable)npe);
        }
        catch (Exception e) {
            this.logger.warn("Error while populating test list, ", (Throwable)e);
        }
        finally {
            return testListOrdered;
        }
    }

    @Override
    public JSONObject getUser() throws ClassCastException {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            return null;
        }
        String url = this.urlManager.getUser("jnk100x987c06f4e10c4", this.apiKey);
        JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
        return jo;
    }

    @Override
    public JSONObject getTestConfig(String testId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)testId)) {
            return null;
        }
        String url = this.urlManager.getTestConfig("jnk100x987c06f4e10c4", this.apiKey, testId);
        JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null);
        return jo;
    }

    @Override
    public JSONObject getCIStatus(String sessionId) throws JSONException, NullPointerException {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        String url = this.urlManager.getCIStatus("jnk100x987c06f4e10c4", this.apiKey, sessionId);
        JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, null).getJSONObject("result");
        return jo;
    }

    void setBlazeMeterURL(String blazeMeterURL) {
        this.urlManager.setServerUrl(blazeMeterURL);
    }

    @Override
    public String getBlazeMeterURL() {
        return this.urlManager.getServerUrl();
    }

    @Override
    public String retrieveJUNITXML(String sessionId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        String url = this.urlManager.retrieveJUNITXML("jnk100x987c06f4e10c4", this.apiKey, sessionId);
        String xmlJunit = this.bzmhc.response(url, null, Method.GET, String.class, null);
        return xmlJunit;
    }

    @Override
    public JSONObject retrieveJtlZip(String sessionId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        this.logger.info("Trying to get JTLZIP url for the sessionId=" + sessionId, new Object[0]);
        String url = this.urlManager.retrieveJTLZIP("jnk100x987c06f4e10c4", this.apiKey, sessionId);
        this.logger.info("Trying to retrieve JTLZIP json for the sessionId=" + sessionId, new Object[0]);
        JSONObject jtlzip = this.bzmhc.response(url, null, Method.GET, JSONObject.class, JSONObject.class);
        return jtlzip;
    }

    @Override
    public StdErrLog getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(StdErrLog logger) {
        this.logger = logger;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public void setHttpUtil(HttpUtil bzmhc) {
        this.bzmhc = bzmhc;
    }

    @Override
    public UrlManager getUrlManager() {
        return this.urlManager;
    }

    @Override
    public JSONObject generatePublicToken(String sessionId) {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        String url = this.urlManager.generatePublicToken("jnk100x987c06f4e10c4", this.apiKey, sessionId);
        JSONObject jo = this.bzmhc.response(url, null, Method.POST, JSONObject.class, JSONObject.class);
        return jo;
    }

    @Override
    public HttpUtil getHttp() {
        return this.bzmhc;
    }

    @Override
    public JSONObject getTestsJSON() {
        String url = this.urlManager.tests("jnk100x987c06f4e10c4", this.apiKey);
        this.logger.info("Getting testList with URL=" + url.substring(0, url.indexOf("?") + 14), new Object[0]);
        JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, JSONObject.class);
        return jo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getListOfSessionIds(String masterId) {
        ArrayList<String> sessionsIds = new ArrayList<String>();
        String url = this.urlManager.listOfSessionIds("jnk100x987c06f4e10c4", this.apiKey, masterId);
        JSONObject jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, JSONObject.class);
        try {
            JSONArray sessions = jo.getJSONObject("result").getJSONArray("sessions");
            int sessionsLength = sessions.length();
            for (int i = 0; i < sessionsLength; ++i) {
                sessionsIds.add(sessions.getJSONObject(i).getString("id"));
            }
        }
        catch (JSONException je) {
            this.logger.info("Failed to get list of sessions from JSONObject " + jo, (Throwable)je);
        }
        catch (Exception e) {
            this.logger.info("Failed to get list of sessions from JSONObject " + jo, (Throwable)e);
        }
        finally {
            return sessionsIds;
        }
    }

    @Override
    public boolean active(String testId) {
        boolean isActive = false;
        String url = this.urlManager.activeTests("jnk100x987c06f4e10c4", this.apiKey);
        JSONObject jo = null;
        try {
            jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, JSONObject.class);
            JSONObject result = null;
            if (jo.has("result") && !jo.get("result").equals(JSONObject.NULL)) {
                result = (JSONObject)jo.get("result");
                JSONArray tests = (JSONArray)result.get("tests");
                for (int i = 0; i < tests.length(); ++i) {
                    if (!String.valueOf(tests.getInt(i)).equals(testId)) continue;
                    isActive = true;
                    return isActive;
                }
                JSONArray collections = (JSONArray)result.get("collections");
                for (int i = 0; i < collections.length(); ++i) {
                    if (!String.valueOf(collections.getInt(i)).equals(testId)) continue;
                    isActive = true;
                    return isActive;
                }
            }
            return isActive;
        }
        catch (JSONException je) {
            this.logger.info("Failed to check if test=" + testId + " is active: received JSON = " + jo, (Throwable)je);
            return false;
        }
        catch (Exception e) {
            this.logger.info("Failed to check if test=" + testId + " is active: received JSON = " + jo, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean ping() throws Exception {
        String url = this.urlManager.version("jnk100x987c06f4e10c4");
        JSONObject jo = null;
        boolean ping = false;
        try {
            jo = this.bzmhc.response(url, null, Method.GET, JSONObject.class, JSONObject.class);
            ping = jo.isNull("error");
        }
        catch (Exception e) {
            this.logger.info("Failed to ping server: " + jo, (Throwable)e);
            throw e;
        }
        return ping;
    }

    @Override
    public boolean notes(String note, String masterId) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)masterId)) {
            return false;
        }
        String noteEsc = StringEscapeUtils.escapeJson((String)("{'note':'" + note + "'}"));
        JSONObject noteJson = new JSONObject(noteEsc);
        String url = this.urlManager.masterId("jnk100x987c06f4e10c4", this.apiKey, masterId);
        JSONObject jo = this.bzmhc.response(url, noteJson, Method.PATCH, JSONObject.class, JSONObject.class);
        try {
            if (!jo.get("error").equals(JSONObject.NULL)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to submit report notest to masterId=" + masterId, e);
        }
        return true;
    }

    @Override
    public boolean properties(JSONArray properties, String sessionId) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.apiKey) & StringUtils.isBlank((CharSequence)sessionId)) {
            return false;
        }
        String url = this.urlManager.properties("jnk100x987c06f4e10c4", this.apiKey, sessionId);
        JSONObject jo = this.bzmhc.response(url, properties, Method.POST, JSONObject.class, JSONArray.class);
        try {
            if (jo.get("result").equals(JSONObject.NULL)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to submit report properties to sessionId=" + sessionId, e);
        }
        return true;
    }
}

