/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.BlazeMeterBuild;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.utils.BuildResult;
import hudson.plugins.blazemeter.utils.JobUtility;
import hudson.plugins.blazemeter.utils.report.BuildReporter;
import hudson.plugins.blazemeter.utils.report.LoggerTask;
import hudson.plugins.blazemeter.utils.report.ReportUrlTask;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PerformanceBuilder
extends Builder {
    private String jobApiKey = "";
    private String serverUrl = "";
    private String testId = "";
    private String notes = "";
    private String sessionProperties = "";
    private String jtlPath = "";
    private String junitPath = "";
    private boolean getJtl = false;
    private boolean getJunit = false;
    private transient String filename;
    @Extension
    public static final BlazeMeterPerformanceBuilderDescriptor DESCRIPTOR = new BlazeMeterPerformanceBuilderDescriptor();

    @DataBoundConstructor
    public PerformanceBuilder(String jobApiKey, String serverUrl, String testId, String notes, String sessionProperties, String jtlPath, String junitPath, boolean getJtl, boolean getJunit) {
        this.jobApiKey = JobUtility.selectUserKeyOnId(DESCRIPTOR, jobApiKey);
        this.serverUrl = serverUrl;
        this.testId = testId;
        this.jtlPath = jtlPath;
        this.junitPath = junitPath;
        this.getJtl = getJtl;
        this.getJunit = getJunit;
        this.notes = notes;
        this.sessionProperties = sessionProperties;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result r = null;
        LoggerTask logTask = null;
        BuildReporter br = new BuildReporter();
        try {
            BlazeMeterBuild b = new BlazeMeterBuild();
            b.setJobApiKey(this.jobApiKey);
            b.setServerUrl(this.serverUrl != null ? this.serverUrl : "https://a.blazemeter.com");
            b.setTestId(this.testId);
            b.setNotes(this.notes);
            b.setSessionProperties(this.sessionProperties);
            b.setJtlPath(this.jtlPath);
            b.setJunitPath(this.junitPath);
            b.setGetJtl(this.getJtl);
            b.setGetJunit(this.getJunit);
            FilePath ws = build.getWorkspace();
            b.setWs(ws);
            String buildId = build.getId();
            b.setBuildId(buildId);
            String jobName = build.getLogFile().getParentFile().getParentFile().getParentFile().getName();
            b.setJobName(jobName);
            VirtualChannel c = launcher.getChannel();
            EnvVars ev = build.getEnvironment((TaskListener)listener);
            b.setEv(ev);
            ReportUrlTask rugt = new ReportUrlTask(build, jobName, c);
            FilePath lp = new FilePath(ws, buildId + File.separator + "bzm-log");
            logTask = new LoggerTask(listener.getLogger(), lp);
            br = new BuildReporter();
            br.run(rugt, logTask);
            r = (Result)c.call((Callable)b);
            return (boolean)r;
        }
        catch (InterruptedException e) {
            r = Result.ABORTED;
            return (boolean)r;
        }
        catch (Exception e) {
            r = Result.FAILURE;
            return (boolean)r;
        }
        finally {
            br.stop();
            BuildResult rstr = BuildResult.valueOf(r.toString());
            build.setResult(r);
            switch (rstr) {
                case FAILURE: {
                    return false;
                }
            }
            return true;
        }
    }

    public String getJobApiKey() {
        return this.jobApiKey;
    }

    public void setJobApiKey(String jobApiKey) {
        this.jobApiKey = jobApiKey;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isGetJtl() {
        return this.getJtl;
    }

    public boolean isGetJunit() {
        return this.getJunit;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getSessionProperties() {
        return this.sessionProperties;
    }

    public String getJtlPath() {
        return this.jtlPath;
    }

    public void setJtlPath(String jtlPath) {
        this.jtlPath = jtlPath;
    }

    public String getJunitPath() {
        return this.junitPath;
    }

    public void setJunitPath(String junitPath) {
        this.junitPath = junitPath;
    }

    public void setSessionProperties(String sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    public BlazeMeterPerformanceBuilderDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends BlazeMeterPerformanceBuilderDescriptor {
        @Override
        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return super.configure(req, formData);
        }
    }
}

