/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.PerformanceReportMap;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

public class PerformanceBuildAction
implements Action,
StaplerProxy {
    private final AbstractBuild<?, ?> build;
    private transient WeakReference<PerformanceReportMap> performanceReportMap;
    private static final Logger logger = Logger.getLogger(PerformanceBuildAction.class.getName());
    private String reportUrl;

    public PerformanceBuildAction(AbstractBuild<?, ?> pBuild) {
        this.build = pBuild;
    }

    public String getDisplayName() {
        return Messages.BuildAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "BlazeMeter";
    }

    public PerformanceReportMap getTarget() {
        return this.getPerformanceReportMap();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public PerformanceReportMap getPerformanceReportMap() {
        PerformanceReportMap reportMap = null;
        WeakReference<PerformanceReportMap> wr = this.performanceReportMap;
        if (wr != null && (reportMap = (PerformanceReportMap)wr.get()) != null) {
            return reportMap;
        }
        try {
            reportMap = new PerformanceReportMap(this, (TaskListener)new StreamTaskListener(System.err));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error creating new PerformanceReportMap()", e);
        }
        this.performanceReportMap = new WeakReference<PerformanceReportMap>(reportMap);
        return reportMap;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }
}

