/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.BaseCredentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Extension;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.utils.JobUtility;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BlazemeterCredentialImpl
extends BaseCredentials
implements StandardCredentials {
    private static final long serialVersionUID = 1L;
    private String apiKey = null;
    private String description = null;

    @DataBoundConstructor
    public BlazemeterCredentialImpl(String apiKey, String description) {
        super(CredentialsScope.GLOBAL);
        this.apiKey = apiKey;
        this.description = description;
    }

    public String getId() {
        return StringUtils.left((String)this.apiKey, (int)4) + "..." + StringUtils.right((String)this.apiKey, (int)4);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getDescription() {
        return this.description;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.BlazemeterCredential_DisplayName();
        }

        public ListBoxModel doFillScopeItems() {
            ListBoxModel m = new ListBoxModel();
            m.add(CredentialsScope.GLOBAL.getDisplayName(), CredentialsScope.GLOBAL.toString());
            return m;
        }

        public FormValidation doTestConnection(@QueryParameter(value="apiKey") String userKey) throws MessagingException, IOException, JSONException, ServletException {
            BlazeMeterPerformanceBuilderDescriptor descriptor = BlazeMeterPerformanceBuilderDescriptor.getDescriptor();
            return JobUtility.validateUserKey(userKey, descriptor.getBlazeMeterURL());
        }
    }
}

