/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.collect.LinkedHashMultimap;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.plugins.blazemeter.BlazemeterCredentialImpl;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.api.ApiV3Impl;
import hudson.plugins.blazemeter.utils.JobUtility;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.json.JSONException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BlazeMeterPerformanceBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    private String blazeMeterURL = "https://a.blazemeter.com";
    private String name = "My BlazeMeter Account";
    private static BlazeMeterPerformanceBuilderDescriptor descriptor = null;

    public BlazeMeterPerformanceBuilderDescriptor() {
        super(PerformanceBuilder.class);
        this.load();
        descriptor = this;
    }

    public static BlazeMeterPerformanceBuilderDescriptor getDescriptor() {
        return descriptor;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "BlazeMeter";
    }

    public ListBoxModel doFillTestIdItems(@QueryParameter(value="jobApiKey") String apiKey, @QueryParameter String apiVersion) throws FormValidation {
        if (apiKey.isEmpty()) {
            ListBoxModel keys = this.getKeys();
            apiKey = ((ListBoxModel.Option)keys.get((int)0)).value;
        }
        ListBoxModel items = new ListBoxModel();
        if (apiKey == null) {
            items.add("No API Key", "-1");
        } else {
            if (apiKey.contains("...")) {
                apiKey = JobUtility.selectUserKeyOnId(this, apiKey);
            }
            ApiV3Impl api = new ApiV3Impl(apiKey, this.blazeMeterURL);
            try {
                LinkedHashMultimap<String, String> testList = api.getTestsMultiMap();
                if (testList == null) {
                    items.add("Invalid API key ", "-1");
                } else if (testList.isEmpty()) {
                    items.add("No tests", "-1");
                } else {
                    Set set = testList.entries();
                    for (Object test : set) {
                        Map.Entry me = (Map.Entry)test;
                        items.add((Object)new ListBoxModel.Option(String.valueOf(me.getValue()) + "->" + me.getKey(), String.valueOf(me.getValue())));
                    }
                }
            }
            catch (Exception e) {
                throw FormValidation.error((String)e.getMessage(), (Object[])new Object[]{e});
            }
        }
        return items;
    }

    public ListBoxModel doFillJobApiKeyItems(@QueryParameter String jobApiKey) {
        ListBoxModel items = this.getKeys();
        for (ListBoxModel.Option option : items) {
            try {
                option.selected = jobApiKey.substring(jobApiKey.length() - 4).equals(option.value.substring(option.value.length() - 4));
            }
            catch (Exception e) {
                option.selected = false;
            }
        }
        return items;
    }

    public List<BlazemeterCredentialImpl> getCredentials(Object scope) {
        ArrayList<BlazemeterCredentialImpl> result = new ArrayList<BlazemeterCredentialImpl>();
        HashSet<String> apiKeys = new HashSet<String>();
        Item item = scope instanceof Item ? (Item)scope : null;
        for (BlazemeterCredentialImpl c : CredentialsProvider.lookupCredentials(BlazemeterCredentialImpl.class, (Item)item, (Authentication)ACL.SYSTEM)) {
            String id = c.getId();
            if (apiKeys.contains(id)) continue;
            result.add(c);
            apiKeys.add(id);
        }
        return result;
    }

    public FormValidation doTestConnection(@QueryParameter(value="apiKey") String userKey) throws MessagingException, IOException, JSONException, ServletException {
        return JobUtility.validateUserKey(userKey, this.blazeMeterURL);
    }

    public ListBoxModel getKeys() {
        ListBoxModel items = new ListBoxModel();
        HashSet<String> apiKeys = new HashSet<String>();
        Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
        for (BlazemeterCredentialImpl c : CredentialsProvider.lookupCredentials(BlazemeterCredentialImpl.class, (Item)item, (Authentication)ACL.SYSTEM)) {
            String id = c.getId();
            if (apiKeys.contains(id)) continue;
            items.add((Object)new ListBoxModel.Option(c.getDescription(), c.getId(), false));
            apiKeys.add(id);
        }
        return items;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String blazeMeterURL = formData.optString("blazeMeterURL");
        this.blazeMeterURL = blazeMeterURL.isEmpty() ? "https://a.blazemeter.com" : blazeMeterURL;
        this.save();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBlazeMeterURL() {
        return this.blazeMeterURL;
    }

    public void setBlazeMeterURL(String blazeMeterURL) {
        this.blazeMeterURL = blazeMeterURL;
    }
}

