/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.api;

import hudson.ProxyConfiguration;
import hudson.model.Hudson;
import hudson.plugins.blazemeter.api.TestInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlazemeterApi {
    PrintStream logger = new PrintStream(System.out);
    public static final String APP_KEY = "jnk100x987c06f4e10c4";
    DefaultHttpClient httpClient;
    BmUrlManager urlManager = new BmUrlManager("https://a.blazemeter.com");

    public BlazemeterApi() {
        try {
            this.httpClient = new DefaultHttpClient();
            this.configureProxy();
        }
        catch (Exception ex) {
            this.logger.format("error Instantiating HTTPClient. Exception received: %s", ex);
        }
    }

    private void configureProxy() {
        if (Hudson.getInstance() != null && Hudson.getInstance().proxy != null) {
            ProxyConfiguration proxy = Hudson.getInstance().proxy;
            if (proxy.name != null && !proxy.name.isEmpty() && proxy.port > 0) {
                if (proxy.getUserName() != null && !proxy.getUserName().isEmpty()) {
                    UsernamePasswordCredentials cred = new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword());
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxy.name, proxy.port), (Credentials)cred);
                }
                HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
                this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            }
        }
    }

    private HttpResponse getResponse(String url, JSONObject data) throws IOException {
        this.logger.println("Requesting : " + url);
        HttpPost postRequest = new HttpPost(url);
        postRequest.setHeader("Accept", "application/json");
        postRequest.setHeader("Content-type", "application/json; charset=UTF-8");
        if (data != null) {
            postRequest.setEntity((HttpEntity)new StringEntity(data.toString()));
        }
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)postRequest);
            int statusCode = response.getStatusLine().getStatusCode();
            String error = response.getStatusLine().getReasonPhrase();
            if (statusCode >= 300 || statusCode < 200) {
                throw new RuntimeException(String.format("Failed : %d %s", statusCode, error));
            }
        }
        catch (Exception e) {
            System.err.format("Wrong response: %s\n", e);
        }
        return response;
    }

    private HttpResponse getResponseForFileUpload(String url, File file) throws IOException {
        this.logger.println("Requesting : " + url);
        HttpPost postRequest = new HttpPost(url);
        postRequest.setHeader("Accept", "application/json");
        postRequest.setHeader("Content-type", "application/json; charset=UTF-8");
        if (file != null) {
            postRequest.setEntity((HttpEntity)new FileEntity(file, "text/plain; charset=\"UTF-8\""));
        }
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)postRequest);
            int statusCode = response.getStatusLine().getStatusCode();
            String error = response.getStatusLine().getReasonPhrase();
            if (statusCode >= 300 || statusCode < 200) {
                throw new RuntimeException(String.format("Failed : %d %s", statusCode, error));
            }
        }
        catch (Exception e) {
            System.err.format("Wrong response: %s\n", e);
        }
        return response;
    }

    private JSONObject getJsonForFileUpload(String url, File file) {
        JSONObject jo = null;
        try {
            HttpResponse response = this.getResponseForFileUpload(url, file);
            if (response != null) {
                String output = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.println(output);
                jo = new JSONObject(output);
            }
        }
        catch (IOException e) {
            this.logger.println("error decoding Json " + e);
        }
        catch (JSONException e) {
            this.logger.println("error decoding Json " + (Object)((Object)e));
        }
        return jo;
    }

    private JSONObject getJson(String url, JSONObject data) {
        JSONObject jo = null;
        try {
            HttpResponse response = this.getResponse(url, data);
            if (response != null) {
                String output = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.println(output);
                jo = new JSONObject(output);
            }
        }
        catch (IOException e) {
            this.logger.println("error decoding Json " + e);
        }
        catch (JSONException e) {
            this.logger.println("error decoding Json " + (Object)((Object)e));
        }
        return jo;
    }

    public synchronized void uploadJmx(String userKey, String testId, File file) {
        if (!this.validate(userKey, testId)) {
            return;
        }
        String url = this.urlManager.scriptUpload(APP_KEY, userKey, testId, file.getName());
        JSONObject json = this.getJsonForFileUpload(url, file);
        try {
            if (!json.get("response_code").equals(200)) {
                this.logger.println("Could not upload file " + file.getName() + " " + json.get("error").toString());
            }
        }
        catch (JSONException e) {
            this.logger.println("Could not upload file " + file.getName() + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized JSONObject uploadBinaryFile(String userKey, String testId, File file) {
        if (!this.validate(userKey, testId)) {
            return null;
        }
        String url = this.urlManager.fileUpload(APP_KEY, userKey, testId, file.getName());
        return this.getJsonForFileUpload(url, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(String fn) {
        StringBuilder contents = new StringBuilder();
        File aFile = new File(fn);
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return contents.toString();
    }

    public TestInfo getTestRunStatus(String userKey, String testId) {
        TestInfo ti = new TestInfo();
        if (!this.validate(userKey, testId)) {
            ti.status = "NotFound";
            return ti;
        }
        try {
            String url = this.urlManager.testStatus(APP_KEY, userKey, testId);
            JSONObject jo = this.getJson(url, null);
            if (jo.get("status") == "Test not found") {
                ti.status = "NotFound";
            } else {
                ti.id = jo.getString("test_id");
                ti.name = jo.getString("test_name");
                ti.status = jo.getString("status");
            }
        }
        catch (Exception e) {
            this.logger.println("error getting status " + e);
            ti.status = "error";
        }
        return ti;
    }

    public synchronized JSONObject startTest(String userKey, String testId) {
        if (!this.validate(userKey, testId)) {
            return null;
        }
        String url = this.urlManager.testStart(APP_KEY, userKey, testId);
        return this.getJson(url, null);
    }

    public int getTestCount(String userKey) throws JSONException, IOException, ServletException {
        if (userKey == null || userKey.trim().isEmpty()) {
            this.logger.println("getTests userKey is empty");
            return 0;
        }
        String url = this.getUrlForTestList(APP_KEY, userKey);
        try {
            JSONObject jo = this.getJson(url, null);
            if (jo == null) {
                return -1;
            }
            String r = jo.get("response_code").toString();
            if (!r.equals("200")) {
                return 0;
            }
            JSONArray arr = (JSONArray)jo.get("tests");
            return arr.length();
        }
        catch (JSONException e) {
            this.logger.println("Error getting response from server: ");
            e.printStackTrace();
            return -1;
        }
    }

    private String getUrlForTestList(String appKey, String userKey) {
        try {
            appKey = URLEncoder.encode(appKey, "UTF-8");
            userKey = URLEncoder.encode(userKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.format("https://a.blazemeter.com/api/rest/blazemeter/getTests.json/?app_key=%s&user_key=%s&test_id=all", appKey, userKey);
    }

    private boolean validate(String userKey, String testId) {
        if (userKey == null || userKey.trim().isEmpty()) {
            this.logger.println("startTest userKey is empty");
            return false;
        }
        if (testId == null || testId.trim().isEmpty()) {
            this.logger.println("testId is empty");
            return false;
        }
        return true;
    }

    public JSONObject stopTest(String userKey, String testId) {
        if (!this.validate(userKey, testId)) {
            return null;
        }
        String url = this.urlManager.testStop(APP_KEY, userKey, testId);
        return this.getJson(url, null);
    }

    public JSONObject aggregateReport(String userKey, String reportId) {
        if (!this.validate(userKey, reportId)) {
            return null;
        }
        String url = this.urlManager.testAggregateReport(APP_KEY, userKey, reportId);
        return this.getJson(url, null);
    }

    public HashMap<String, String> getTestList(String userKey) throws IOException, MessagingException {
        LinkedHashMap<String, String> testListOrdered;
        block9: {
            testListOrdered = null;
            if (userKey == null || userKey.trim().isEmpty()) {
                this.logger.println("getTests userKey is empty");
            } else {
                String url = this.getUrlForTestList(APP_KEY, userKey);
                this.logger.println(url);
                JSONObject jo = this.getJson(url, null);
                try {
                    String r = jo.get("response_code").toString();
                    if (!r.equals("200")) break block9;
                    JSONArray arr = (JSONArray)jo.get("tests");
                    testListOrdered = new LinkedHashMap<String, String>(arr.length());
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject en = null;
                        try {
                            en = arr.getJSONObject(i);
                        }
                        catch (JSONException e) {
                            this.logger.println("Error with the JSON while populating test list, " + (Object)((Object)e));
                        }
                        try {
                            if (en == null) continue;
                            String id = en.getString("test_id");
                            String name = en.getString("test_name").replaceAll("&", "&amp;");
                            testListOrdered.put(name, id);
                            continue;
                        }
                        catch (JSONException ie) {
                            this.logger.println("Error with the JSON while populating test list, " + (Object)((Object)ie));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.println("Error while populating test list, " + e);
                }
            }
        }
        return testListOrdered;
    }

    public static class BmUrlManager {
        private String SERVER_URL = "https://a.blazemeter.com/";

        public BmUrlManager(String blazeMeterUrl) {
            this.SERVER_URL = blazeMeterUrl;
        }

        public String getServerUrl() {
            return this.SERVER_URL;
        }

        public String testStatus(String appKey, String userKey, String testId) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                testId = URLEncoder.encode(testId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testGetStatus.json/?app_key=%s&user_key=%s&test_id=%s", appKey, userKey, testId);
        }

        public String scriptUpload(String appKey, String userKey, String testId, String fileName) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                testId = URLEncoder.encode(testId, "UTF-8");
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testScriptUpload.json/?app_key=%s&user_key=%s&test_id=%s&file_name=%s", appKey, userKey, testId, fileName);
        }

        public String fileUpload(String appKey, String userKey, String testId, String fileName) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                testId = URLEncoder.encode(testId, "UTF-8");
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testArtifactUpload.json/?app_key=%s&user_key=%s&test_id=%s&file_name=%s", appKey, userKey, testId, fileName);
        }

        public String testStart(String appKey, String userKey, String testId) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                testId = URLEncoder.encode(testId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testStart.json/?app_key=%s&user_key=%s&test_id=%s", appKey, userKey, testId);
        }

        public String testStop(String appKey, String userKey, String testId) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                testId = URLEncoder.encode(testId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testStop.json/?app_key=%s&user_key=%s&test_id=%s", appKey, userKey, testId);
        }

        public String testAggregateReport(String appKey, String userKey, String reportId) {
            try {
                appKey = URLEncoder.encode(appKey, "UTF-8");
                userKey = URLEncoder.encode(userKey, "UTF-8");
                reportId = URLEncoder.encode(reportId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return String.format("https://a.blazemeter.com/api/rest/blazemeter/testGetReport.json/?app_key=%s&user_key=%s&report_id=%s&get_aggregate=true", appKey, userKey, reportId);
        }
    }

    public class TestStatus {
        public static final String Running = "Running";
        public static final String NotRunning = "Not Running";
        public static final String NotFound = "NotFound";
        public static final String Error = "error";
    }
}

