/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.blazemeter.AbstractReport;
import hudson.plugins.blazemeter.HttpSample;
import hudson.plugins.blazemeter.PerformanceReport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriReport
extends AbstractReport
implements ModelObject,
Comparable<UriReport> {
    public static final String END_PERFORMANCE_PARAMETER = ".endperformanceparameter";
    private final List<HttpSample> httpSampleList = new ArrayList<HttpSample>();
    private final PerformanceReport performanceReport;
    private final String staplerUri;
    private UriReport lastBuildUriReport;
    private String uri;

    UriReport(PerformanceReport performanceReport, String staplerUri, String uri) {
        this.performanceReport = performanceReport;
        this.staplerUri = staplerUri;
        this.uri = uri;
    }

    public void addHttpSample(HttpSample httpSample) {
        this.httpSampleList.add(httpSample);
    }

    @Override
    public int compareTo(UriReport uriReport) {
        if (uriReport == this) {
            return 0;
        }
        return uriReport.getUri().compareTo(this.getUri());
    }

    @Override
    public int countErrors() {
        int nbError = 0;
        for (HttpSample currentSample : this.httpSampleList) {
            if (currentSample.isSuccessful()) continue;
            ++nbError;
        }
        return nbError;
    }

    @Override
    public double errorPercent() {
        return (double)this.countErrors() / (double)this.size() * 100.0;
    }

    @Override
    public long getAverage() {
        long average = 0L;
        for (HttpSample currentSample : this.httpSampleList) {
            average += currentSample.getDuration();
        }
        return average / (long)this.size();
    }

    @Override
    public long get90Line() {
        long result = 0L;
        Collections.sort(this.httpSampleList);
        if (this.httpSampleList.size() > 0) {
            result = this.httpSampleList.get((int)((double)this.httpSampleList.size() * 0.9)).getDuration();
        }
        return result;
    }

    @Override
    public String getHttpCode() {
        String result = "";
        for (HttpSample currentSample : this.httpSampleList) {
            if (result.matches(".*" + currentSample.getHttpCode() + ".*")) continue;
            result = result + (result.length() > 1 ? "," + currentSample.getHttpCode() : currentSample.getHttpCode());
        }
        return result;
    }

    @Override
    public long getMedian() {
        long result = 0L;
        Collections.sort(this.httpSampleList);
        if (this.httpSampleList.size() > 0) {
            result = this.httpSampleList.get((int)((double)this.httpSampleList.size() * 0.5)).getDuration();
        }
        return result;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.performanceReport.getBuild();
    }

    public String getDisplayName() {
        return this.getUri();
    }

    public List<HttpSample> getHttpSampleList() {
        return this.httpSampleList;
    }

    public PerformanceReport getPerformanceReport() {
        return this.performanceReport;
    }

    @Override
    public long getMax() {
        long max = Long.MIN_VALUE;
        for (HttpSample currentSample : this.httpSampleList) {
            max = Math.max(max, currentSample.getDuration());
        }
        return max;
    }

    @Override
    public long getMin() {
        long min = Long.MAX_VALUE;
        for (HttpSample currentSample : this.httpSampleList) {
            min = Math.min(min, currentSample.getDuration());
        }
        return min;
    }

    public String getStaplerUri() {
        return this.staplerUri;
    }

    public String getUri() {
        return this.uri;
    }

    public String getShortUri() {
        if (this.uri.length() > 130) {
            return this.uri.substring(0, 129);
        }
        return this.uri;
    }

    public boolean isFailed() {
        return this.countErrors() != 0;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public int size() {
        return this.httpSampleList.size();
    }

    public String encodeUriReport() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.performanceReport.getReportFileName()).append(";").append(this.getStaplerUri()).append(END_PERFORMANCE_PARAMETER);
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }

    public void addLastBuildUriReport(UriReport lastBuildUriReport) {
        this.lastBuildUriReport = lastBuildUriReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildUriReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildUriReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildUriReport == null) {
            return 0.0;
        }
        return this.errorPercent() - this.lastBuildUriReport.errorPercent();
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        if (this.lastBuildUriReport == null) {
            return "";
        }
        if (this.lastBuildUriReport.getHttpCode().equals(this.getHttpCode())) {
            return "";
        }
        return this.lastBuildUriReport.getHttpCode();
    }

    @Override
    public int getSizeDiff() {
        if (this.lastBuildUriReport == null) {
            return 0;
        }
        return this.size() - this.lastBuildUriReport.size();
    }
}

