/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.LoadReportParser;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.PerformanceBuildAction;
import hudson.plugins.blazemeter.PerformanceProjectAction;
import hudson.plugins.blazemeter.PerformanceReport;
import hudson.plugins.blazemeter.PerformanceReportParser;
import hudson.plugins.blazemeter.UriReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceReportMap
implements ModelObject {
    private transient PerformanceBuildAction buildAction;
    private Map<String, PerformanceReport> performanceReportMap = new LinkedHashMap<String, PerformanceReport>();
    private static final String PERFORMANCE_REPORTS_DIRECTORY = "jenkins-reports";
    private static AbstractBuild<?, ?> currentBuild = null;

    public String getSession() {
        return this.buildAction.getSession();
    }

    public String getBlazeMeterURL() {
        return this.buildAction.getBlazeMeterURL();
    }

    PerformanceReportMap(final PerformanceBuildAction buildAction, TaskListener listener) throws IOException {
        this.buildAction = buildAction;
        this.parseReports(this.getBuild(), listener, new PerformanceReportCollector(){

            @Override
            public void addAll(Collection<PerformanceReport> reports) {
                for (PerformanceReport r : reports) {
                    r.setBuildAction(buildAction);
                    PerformanceReportMap.this.performanceReportMap.put(r.getReportFileName(), r);
                }
            }
        }, null);
    }

    private void addAll(Collection<PerformanceReport> reports) {
        for (PerformanceReport r : reports) {
            r.setBuildAction(this.buildAction);
            this.performanceReportMap.put(r.getReportFileName(), r);
        }
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        if ("".equals(Messages.Report_DisplayName())) {
            return "https://a.blazemeter.com/";
        }
        return Messages.Report_DisplayName();
    }

    public List<PerformanceReport> getPerformanceListOrdered() {
        ArrayList<PerformanceReport> listPerformance = new ArrayList<PerformanceReport>(this.getPerformanceReportMap().values());
        Collections.sort(listPerformance);
        return listPerformance;
    }

    public Map<String, PerformanceReport> getPerformanceReportMap() {
        return this.performanceReportMap;
    }

    public PerformanceReport getPerformanceReport(String performanceReportName) {
        return this.performanceReportMap.get(performanceReportName);
    }

    public UriReport getUriReport(String uriReport) {
        if (uriReport != null) {
            String uriReportDecoded;
            try {
                uriReportDecoded = URLDecoder.decode(uriReport.replace(".endperformanceparameter", ""), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
            StringTokenizer st = new StringTokenizer(uriReportDecoded, ";");
            return this.getPerformanceReportMap().get(st.nextToken()).getUriReportMap().get(st.nextToken());
        }
        return null;
    }

    public String getUrlName() {
        return "performanceReportList";
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setPerformanceReportMap(Map<String, PerformanceReport> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }

    public static String getPerformanceReportFileRelativePath(String parserDisplayName, String reportFileName) {
        return PerformanceReportMap.getRelativePath(parserDisplayName, reportFileName);
    }

    public static String getPerformanceReportDirRelativePath() {
        return PerformanceReportMap.getRelativePath(new String[0]);
    }

    private static String getRelativePath(String ... suffixes) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(PERFORMANCE_REPORTS_DIRECTORY);
        for (String suffix : suffixes) {
            sb.append(File.separator).append(suffix);
        }
        return sb.toString();
    }

    public boolean isFailed(String performanceReportName) {
        return this.getPerformanceReport(performanceReportName) == null;
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        final LinkedHashMap buildReports = new LinkedHashMap();
        for (AbstractBuild previousBuild = this.getBuild(); previousBuild != null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
            final AbstractBuild currentBuild = previousBuild;
            this.parseReports(currentBuild, TaskListener.NULL, new PerformanceReportCollector(){

                @Override
                public void addAll(Collection<PerformanceReport> parse) {
                    for (PerformanceReport performanceReport : parse) {
                        if (buildReports.get(currentBuild) == null) {
                            LinkedHashMap map = new LinkedHashMap();
                            buildReports.put(currentBuild, map);
                        }
                        ((Map)buildReports.get(currentBuild)).put(performanceReport.getReportFileName(), performanceReport);
                    }
                }
            }, parameter);
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        for (AbstractBuild currentBuild : buildReports.keySet()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            PerformanceReport report = (PerformanceReport)((Map)buildReports.get(currentBuild)).get(parameter);
            dataSetBuilderAverage.add((Number)report.getAverage(), (Comparable)((Object)Messages.ProjectAction_Average()), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)400, (int)200);
    }

    private void parseReports(AbstractBuild<?, ?> build, TaskListener listener, PerformanceReportCollector collector, final String filename) throws IOException {
        File[] dirs;
        File repo = new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportDirRelativePath());
        File[] files = repo.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return !f.isDirectory();
            }
        });
        if (files != null) {
            this.addAll(new LoadReportParser("").parse(build, Arrays.asList(files), listener));
        }
        if ((dirs = repo.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (File dir : dirs) {
                PerformanceReportParser p = this.buildAction.getParserByDisplayName(dir.getName());
                if (p == null) continue;
                File[] listFiles = dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (filename == null) {
                            return true;
                        }
                        return name.equals(filename);
                    }
                });
                collector.addAll(p.parse(build, Arrays.asList(listFiles), listener));
            }
        }
        this.addPreviousBuildReports();
    }

    private void addPreviousBuildReports() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        AbstractBuild previousBuild = (AbstractBuild)this.getBuild().getPreviousBuild();
        if (previousBuild == null) {
            return;
        }
        PerformanceBuildAction previousPerformanceAction = (PerformanceBuildAction)previousBuild.getAction(PerformanceBuildAction.class);
        if (previousPerformanceAction == null) {
            return;
        }
        PerformanceReportMap previousPerformanceReportMap = previousPerformanceAction.getPerformanceReportMap();
        if (previousPerformanceReportMap == null) {
            return;
        }
        for (Map.Entry<String, PerformanceReport> item : this.getPerformanceReportMap().entrySet()) {
            PerformanceReport lastReport = previousPerformanceReportMap.getPerformanceReportMap().get(item.getKey());
            if (lastReport == null) continue;
            item.getValue().setLastBuildReport(lastReport);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PerformanceReportCollector {
        public void addAll(Collection<PerformanceReport> var1);
    }
}

