/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.plugins.blazemeter.BlazemeterCredential;
import hudson.plugins.blazemeter.PerformanceBuildAction;
import hudson.plugins.blazemeter.PerformanceProjectAction;
import hudson.plugins.blazemeter.PerformanceReportMap;
import hudson.plugins.blazemeter.PerformanceReportParser;
import hudson.plugins.blazemeter.api.AggregateTestResult;
import hudson.plugins.blazemeter.api.BlazemeterApi;
import hudson.plugins.blazemeter.api.TestInfo;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformancePublisher
extends Notifier {
    DateFormat df = new SimpleDateFormat("dd/MM/yy");
    private String apiKey;
    private String testId = "";
    private String testDuration = "180";
    private String mainJMX = "";
    private String dataFolder = "";
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private int responseTimeFailedThreshold = 0;
    private int responseTimeUnstableThreshold = 0;
    private transient String filename;
    private List<PerformanceReportParser> parsers = null;
    List<PerformanceProjectAction> performanceProjectActions = new ArrayList<PerformanceProjectAction>();
    private String blazeMeterURL;
    @Extension
    public static final BlazeMeterPerformancePublisherDescriptor DESCRIPTOR = new BlazeMeterPerformancePublisherDescriptor();

    @DataBoundConstructor
    public PerformancePublisher(String apiKey, String testDuration, String mainJMX, String dataFolder, String testId, int errorFailedThreshold, int errorUnstableThreshold, int responseTimeFailedThreshold, int responseTimeUnstableThreshold) {
        this.apiKey = apiKey;
        this.errorFailedThreshold = errorFailedThreshold;
        this.errorUnstableThreshold = errorUnstableThreshold;
        this.testId = testId;
        this.testDuration = testDuration;
        this.mainJMX = mainJMX;
        this.dataFolder = dataFolder;
        this.responseTimeFailedThreshold = responseTimeFailedThreshold;
        this.responseTimeUnstableThreshold = responseTimeUnstableThreshold;
    }

    public static File getPerformanceReport(AbstractBuild<?, ?> build, String parserDisplayName, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public List<PerformanceReportParser> getParsers() {
        return this.parsers;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    protected static List<FilePath> locatePerformanceReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(includes);
            if (ret.length > 0) {
                return Arrays.asList(ret);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/*")));
                continue;
            }
            files.add(src);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String session;
        JSONObject json;
        PrintStream logger = listener.getLogger();
        int runDurationSeconds = Integer.parseInt(this.testDuration) * 60;
        Result result = this.validateThresholds(logger);
        if (result != Result.SUCCESS) {
            return true;
        }
        String apiKeyId = StringUtils.defaultIfEmpty((String)this.getApiKey(), (String)this.getDescriptor().getApiKey());
        String apiKey = null;
        for (BlazemeterCredential c : CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (Item)build.getProject(), (Authentication)ACL.SYSTEM)) {
            if (!StringUtils.equals((String)apiKeyId, (String)c.getId())) continue;
            apiKey = c.getApiKey().getPlainText();
            break;
        }
        BlazemeterApi bmAPI = new BlazemeterApi();
        this.uploadDataFolderFiles(apiKey, this.testId, bmAPI, logger);
        int countStartRequests = 0;
        do {
            logger.print(".");
            json = bmAPI.startTest(apiKey, this.testId);
            if (++countStartRequests <= 5) continue;
            logger.println("Could not start BlazeMeter Test");
            result = Result.NOT_BUILT;
            return false;
        } while (json == null);
        try {
            if (!json.get("response_code").equals(200)) {
                if (json.get("response_code").equals(500) && json.get("error").toString().startsWith("Test already running")) {
                    logger.println("Test already running, please stop it first");
                    result = Result.NOT_BUILT;
                    return false;
                }
                logger.print(".");
                json = bmAPI.startTest(apiKey, this.testId);
                if (json == null) {
                    logger.println("Could not start BlazeMeter Test");
                    result = Result.NOT_BUILT;
                    return false;
                }
                if (!json.get("response_code").equals(200)) {
                    logger.println("Could not start BlazeMeter Test -" + json.get("error").toString());
                    result = Result.NOT_BUILT;
                    return false;
                }
            }
            session = json.get("session_id").toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.println("Error: Exception while starting BlazeMeter Test [" + e.getMessage() + "]");
            return false;
        }
        PerformanceBuildAction a = new PerformanceBuildAction(build, logger, this.parsers);
        a.setSession(session);
        a.setBlazeMeterURL(DESCRIPTOR.blazeMeterURL);
        build.addAction((Action)a);
        Date start = null;
        long lastPrint = 0L;
        while (true) {
            TestInfo info;
            if ((info = bmAPI.getTestRunStatus(apiKey, this.testId)).getStatus().equals("error")) {
                build.setResult(Result.NOT_BUILT);
                logger.println("Error while running a test - please try to run the same test on BlazeMeter");
                return true;
            }
            if (info.getStatus().equals("NotFound")) {
                build.setResult(Result.NOT_BUILT);
                logger.println("Test not found error");
                return true;
            }
            if (info.getStatus().equals("Running")) {
                if (start == null) {
                    start = Calendar.getInstance().getTime();
                }
                build.setResult(Result.SUCCESS);
                long now = Calendar.getInstance().getTime().getTime();
                long diffInSec = (now - start.getTime()) / 1000L;
                if (now - lastPrint > 10000L) {
                    logger.println("BlazeMeter test running from " + start + " - for " + diffInSec + " seconds");
                    lastPrint = now;
                }
                if (diffInSec < (long)runDurationSeconds) continue;
                bmAPI.stopTest(apiKey, this.testId);
                logger.println("BlazeMeter test stopped due to user test duration setup reached");
                break;
            }
            if (info.getStatus().equals("Not Running")) break;
        }
        logger.println("BlazeMeter test running terminated at " + Calendar.getInstance().getTime());
        Thread.sleep(10000L);
        json = bmAPI.aggregateReport(apiKey, session);
        for (int i = 0; i < 200; ++i) {
            try {
                if (!json.get("response_code").equals(404)) break;
                json = bmAPI.aggregateReport(apiKey, session);
                continue;
            }
            catch (JSONException e) {
                continue;
            }
            finally {
                Thread.sleep(5000L);
            }
        }
        String aggregate = "null";
        for (int i = 0; i < 30; ++i) {
            try {
                if (!json.get("response_code").equals(200)) {
                    logger.println("Error: Requesting aggregate report response code:" + json.get("response_code"));
                }
                aggregate = json.getJSONObject("report").get("aggregate").toString();
            }
            catch (JSONException e) {
                logger.println("Error: Exception while starting BlazeMeter Test [" + e.getMessage() + "]");
                e.printStackTrace();
            }
            if (!aggregate.equals("null")) break;
            Thread.sleep(2000L);
            json = bmAPI.aggregateReport(apiKey, session);
        }
        if (aggregate == null) {
            logger.println("Error: Requesting aggregate is not available");
            build.setResult(Result.NOT_BUILT);
            return false;
        }
        AggregateTestResult aggregateTestResult = AggregateTestResult.generate(aggregate);
        if (aggregateTestResult == null) {
            logger.println("Error: Requesting aggregate Test Result is not available");
            build.setResult(Result.NOT_BUILT);
            return false;
        }
        if (this.performanceProjectActions.size() > 0) {
            this.performanceProjectActions.get((int)(this.performanceProjectActions.size() - 1)).lastReportSession = session;
            this.performanceProjectActions.get((int)(this.performanceProjectActions.size() - 1)).lastBlazeMeterURL = DESCRIPTOR.blazeMeterURL;
        }
        double thresholdTolerance = 5.0E-5;
        double errorPercent = aggregateTestResult.getErrorPercentage();
        double AverageResponseTime = aggregateTestResult.getAverage();
        if (this.errorFailedThreshold >= 0 && errorPercent - (double)this.errorFailedThreshold > thresholdTolerance) {
            result = Result.FAILURE;
            logger.println("Test ended with " + Result.FAILURE + " on error percentage threshold");
        } else if (this.errorUnstableThreshold >= 0 && errorPercent - (double)this.errorUnstableThreshold > thresholdTolerance) {
            logger.println("Test ended with " + Result.UNSTABLE + " on error percentage threshold");
            result = Result.UNSTABLE;
        }
        if (this.responseTimeFailedThreshold >= 0 && AverageResponseTime - (double)this.responseTimeFailedThreshold > thresholdTolerance) {
            result = Result.FAILURE;
            build.setResult(Result.FAILURE);
            logger.println("Test ended with " + Result.FAILURE + " on response time threshold");
        } else if (this.responseTimeUnstableThreshold >= 0 && AverageResponseTime - (double)this.responseTimeUnstableThreshold > thresholdTolerance) {
            result = Result.UNSTABLE;
            logger.println("Test ended with " + Result.UNSTABLE + " on response time threshold");
        }
        build.setResult(result);
        return true;
    }

    private void uploadDataFolderFiles(String apiKey, String testId, BlazemeterApi bmAPI, PrintStream logger) {
        if (this.dataFolder == null || this.dataFolder.isEmpty()) {
            return;
        }
        File folder = new File(this.dataFolder);
        if (!folder.exists() || !folder.isDirectory()) {
            logger.println("dataFolder " + this.dataFolder + " could not be found on local file system, please check that the folder exists.");
            return;
        }
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile()) continue;
                String fileName = file.getName();
                if (fileName.endsWith(this.mainJMX)) {
                    bmAPI.uploadJmx(apiKey, testId, file);
                    continue;
                }
                this.uploadFile(apiKey, testId, bmAPI, file, logger);
            }
        }
    }

    private void uploadFile(String apiKey, String testId, BlazemeterApi bmAPI, File file, PrintStream logger) {
        String fileName = file.getName();
        JSONObject json = bmAPI.uploadBinaryFile(apiKey, testId, file);
        try {
            if (!json.get("response_code").equals(200)) {
                logger.println("Could not upload file " + fileName + " " + json.get("error").toString());
            }
        }
        catch (JSONException e) {
            logger.println("Could not upload file " + fileName + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Result validateThresholds(PrintStream logger) {
        Result result = Result.SUCCESS;
        if (this.errorUnstableThreshold >= 0 && this.errorUnstableThreshold <= 100) {
            logger.println("BlazeMeter: Errors percentage greater or equal than " + this.errorUnstableThreshold + "% will be considered as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("BlazeMeter: percentage should be between 0 to 100");
            result = Result.NOT_BUILT;
        }
        if (this.errorFailedThreshold >= 0 && this.errorFailedThreshold <= 100) {
            logger.println("BlazeMeter: Errors percentage greater or equal than " + this.errorFailedThreshold + "% will be considered as " + Result.FAILURE.toString().toLowerCase());
        } else {
            logger.println("BlazeMeter: percentage should be between 0 to 100");
            result = Result.NOT_BUILT;
        }
        if (this.responseTimeUnstableThreshold >= 0) {
            logger.println("BlazeMeter: Response time greater or equal than " + this.responseTimeUnstableThreshold + "millis will be considered as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("BlazeMeter: percentage should be greater or equal than 0");
            result = Result.NOT_BUILT;
        }
        if (this.responseTimeFailedThreshold >= 0) {
            logger.println("BlazeMeter: Response time greater or equal than " + this.responseTimeFailedThreshold + "millis will be considered as " + Result.FAILURE.toString().toLowerCase());
        } else {
            logger.println("BlazeMeter: percentage should be greater or equal than 0");
            result = Result.NOT_BUILT;
        }
        return result;
    }

    private List<File> copyReportsToMaster(AbstractBuild<?, ?> build, PrintStream logger, List<FilePath> files, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        for (FilePath src : files) {
            File localReport = PerformancePublisher.getPerformanceReport(build, parserDisplayName, src.getName());
            if (src.isDirectory()) {
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
                continue;
            }
            src.copyTo(new FilePath(localReport));
            localReports.add(localReport);
        }
        return localReports;
    }

    public Object readResolve() {
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getResponseTimeFailedThreshold() {
        return this.responseTimeFailedThreshold;
    }

    public void setResponseTimeFailedThreshold(int responseTimeFailedThreshold) {
        this.responseTimeFailedThreshold = responseTimeFailedThreshold;
    }

    public int getResponseTimeUnstableThreshold() {
        return this.responseTimeUnstableThreshold;
    }

    public void setResponseTimeUnstableThreshold(int responseTimeUnstableThreshold) {
        this.responseTimeUnstableThreshold = responseTimeUnstableThreshold;
    }

    public String getTestDuration() {
        return this.testDuration;
    }

    public void setTestDuration(String testDuration) {
        this.testDuration = testDuration;
    }

    public String getMainJMX() {
        return this.mainJMX;
    }

    public void setMainJMX(String mainJMX) {
        this.mainJMX = mainJMX;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public void setDataFolder(String dataFolder) {
        this.dataFolder = dataFolder;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public BlazeMeterPerformancePublisherDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlazeMeterPerformancePublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String blazeMeterURL = "https://a.blazemeter.com";
        private String name = "My BlazeMeter Account";
        private String apiKey;

        public BlazeMeterPerformancePublisherDescriptor() {
            super(PerformancePublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "BlazeMeter";
        }

        public ListBoxModel doFillTestIdItems(@QueryParameter String apiKey) throws FormValidation {
            if (StringUtils.isBlank((String)apiKey)) {
                apiKey = this.getApiKey();
            }
            Secret apiSecret = null;
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            for (BlazemeterCredential c : CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                if (!StringUtils.equals((String)apiKey, (String)c.getId())) continue;
                apiSecret = c.getApiKey();
                break;
            }
            ListBoxModel items = new ListBoxModel();
            if (apiSecret == null) {
                items.add("No API Key", "-1");
            } else {
                BlazemeterApi bzm = new BlazemeterApi();
                try {
                    HashMap<String, String> testList = bzm.getTestList(apiSecret.getPlainText());
                    if (testList == null) {
                        items.add("Invalid API key ", "-1");
                    } else if (testList.isEmpty()) {
                        items.add("No tests", "-1");
                    } else {
                        Set<Map.Entry<String, String>> set = testList.entrySet();
                        Iterator<Map.Entry<String, String>> i$ = set.iterator();
                        while (i$.hasNext()) {
                            Map.Entry<String, String> test;
                            Map.Entry<String, String> me = test = i$.next();
                            items.add(me.getKey(), String.valueOf(me.getValue()));
                        }
                    }
                }
                catch (Exception e) {
                    throw FormValidation.error((String)e.getMessage(), (Object[])new Object[]{e});
                }
            }
            return items;
        }

        public ListBoxModel doFillApiKeyItems() {
            List global;
            ListBoxModel items = new ListBoxModel();
            HashSet<String> apiKeys = new HashSet<String>();
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            if (item instanceof Job && !(global = CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM)).isEmpty() && !StringUtils.isEmpty((String)this.getApiKey())) {
                items.add("Default API Key", "");
            }
            for (BlazemeterCredential c : CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                String id = c.getId();
                if (apiKeys.contains(id)) continue;
                items.add(StringUtils.defaultIfEmpty((String)c.getDescription(), (String)id), id);
                apiKeys.add(id);
            }
            return items;
        }

        public List<BlazemeterCredential> getCredentials(Object scope) {
            ArrayList<BlazemeterCredential> result = new ArrayList<BlazemeterCredential>();
            HashSet<String> apiKeys = new HashSet<String>();
            Item item = scope instanceof Item ? (Item)scope : null;
            for (BlazemeterCredential c : CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                String id = c.getId();
                if (apiKeys.contains(id)) continue;
                result.add(c);
                apiKeys.add(id);
            }
            return result;
        }

        public FormValidation doTestConnection(@QueryParameter(value="apiKey") String userKey) throws MessagingException, IOException, JSONException, ServletException {
            BlazemeterApi bzm = new BlazemeterApi();
            int testCount = bzm.getTestCount(userKey);
            if (testCount < 0) {
                return FormValidation.errorWithMarkup((String)"An error as occurred, check proxy settings");
            }
            if (testCount == 0) {
                return FormValidation.errorWithMarkup((String)"User Key Invalid Or No Available Tests");
            }
            return FormValidation.ok((String)("User Key Valid. " + testCount + " Available Tests"));
        }

        public boolean configure(StaplerRequest req, net.sf.json.JSONObject formData) throws Descriptor.FormException {
            this.apiKey = formData.optString("apiKey");
            this.save();
            return true;
        }

        public String getBlazeMeterURL() {
            return this.blazeMeterURL;
        }

        public void setBlazeMeterURL(String blazeMeterURL) {
            this.blazeMeterURL = blazeMeterURL;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getApiKey() {
            List credentials = CredentialsProvider.lookupCredentials(BlazemeterCredential.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM);
            if (StringUtils.isBlank((String)this.apiKey) && !credentials.isEmpty()) {
                return ((BlazemeterCredential)credentials.get(0)).getId();
            }
            if (credentials.size() == 1) {
                return ((BlazemeterCredential)credentials.get(0)).getId();
            }
            for (BlazemeterCredential c : credentials) {
                if (!StringUtils.equals((String)c.getId(), (String)this.apiKey)) continue;
                return this.apiKey;
            }
            return "";
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }
    }

    public static final class DescriptorImpl
    extends BlazeMeterPerformancePublisherDescriptor {
    }
}

