/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.blazemeter.GraphConfigurationDetail;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.PerformanceBuildAction;
import hudson.plugins.blazemeter.PerformanceReport;
import hudson.plugins.blazemeter.PerformanceReportPosition;
import hudson.plugins.blazemeter.TrendReportDetail;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerformanceProjectAction
implements Action {
    private static final String CONFIGURE_LINK = "configure";
    private static final String TRENDREPORT_LINK = "blazeMeterReport";
    private static final String PLUGIN_NAME = "BlazeMeter";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PerformanceProjectAction.class.getName());
    public final AbstractProject<?, ?> project;
    private transient List<String> performanceReportList;
    public String lastBlazeMeterURL = "";
    public String lastReportSession = "";

    public String getDisplayName() {
        return Messages.ProjectAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    public String getLastReportSession() {
        return this.lastReportSession;
    }

    public String getLastBlazeMeterURL() {
        return this.lastBlazeMeterURL;
    }

    public PerformanceProjectAction(AbstractProject project) {
        this.project = project;
    }

    private JFreeChart createErrorsChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_PercentageOfErrors(), null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected static JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_RespondingTime(), null, (String)"ms", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public void doErrorsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        String performanceReportNameFile = performanceReportPosition.getPerformanceReportPosition();
        if (performanceReportNameFile == null) {
            if (this.getPerformanceReportList().size() == 1) {
                performanceReportNameFile = this.getPerformanceReportList().get(0);
            } else {
                return;
            }
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderErrors = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        List<Integer> buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (nbBuildsToAnalyze <= buildsLimits.get(1) && buildsLimits.get(0) <= nbBuildsToAnalyze) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderErrors.add((Number)performanceReport.errorPercent(), (Comparable)((Object)Messages.ProjectAction_Errors()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createErrorsChart(dataSetBuilderErrors.build()), (int)400, (int)200);
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        String performanceReportNameFile = performanceReportPosition.getPerformanceReportPosition();
        if (performanceReportNameFile == null) {
            if (this.getPerformanceReportList().size() == 1) {
                performanceReportNameFile = this.getPerformanceReportList().get(0);
            } else {
                return;
            }
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        List<Integer> buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (nbBuildsToAnalyze <= buildsLimits.get(1) && buildsLimits.get(0) <= nbBuildsToAnalyze) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderAverage.add((Number)performanceReport.getMedian(), (Comparable)((Object)Messages.ProjectAction_Median()), (Comparable)label);
                dataSetBuilderAverage.add((Number)performanceReport.getAverage(), (Comparable)((Object)Messages.ProjectAction_Average()), (Comparable)label);
                dataSetBuilderAverage.add((Number)performanceReport.get90Line(), (Comparable)((Object)Messages.ProjectAction_Line90()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)400, (int)200);
    }

    private List<Integer> getFirstAndLastBuild(StaplerRequest request, List<?> builds) {
        ArrayList<Integer> outList = new ArrayList<Integer>(2);
        GraphConfigurationDetail graphConf = (GraphConfigurationDetail)this.createUserConfiguration(request);
        String configType = graphConf.getConfigType();
        if (configType.compareToIgnoreCase("BUILD") == 0) {
            if (graphConf.getBuildCount() <= 0) {
                configType = "NONE";
            } else {
                if (builds.size() - graphConf.getBuildCount() > 0) {
                    outList.add(builds.size() - graphConf.getBuildCount() + 1);
                } else {
                    outList.add(1);
                }
                outList.add(builds.size());
            }
        } else if (configType.compareToIgnoreCase("DATE") == 0) {
            if ("dd/MM/yyyy".compareTo(graphConf.getFirstDayCount()) == 0 && "dd/MM/yyyy".compareTo(graphConf.getLastDayCount()) == 0) {
                configType = "NONE";
            } else {
                int firstBuild = -1;
                int lastBuild = -1;
                int var = builds.size();
                GregorianCalendar firstDate = null;
                GregorianCalendar lastDate = null;
                try {
                    firstDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getFirstDayCount());
                    lastDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getLastDayCount());
                    lastDate.set(11, 23);
                    lastDate.set(12, 59);
                    lastDate.set(13, 59);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.SEVERE, "Error during the manage of the Calendar", e);
                }
                for (AbstractBuild currentBuild : builds) {
                    GregorianCalendar buildDate = new GregorianCalendar();
                    buildDate.setTime(currentBuild.getTimestamp().getTime());
                    if (firstDate.getTime().before(buildDate.getTime())) {
                        firstBuild = var;
                    }
                    if (lastBuild < 0 && lastDate.getTime().after(buildDate.getTime())) {
                        lastBuild = var;
                    }
                    --var;
                }
                outList.add(firstBuild);
                outList.add(lastBuild);
            }
        }
        if (configType.compareToIgnoreCase("NONE") == 0) {
            outList.add(1);
            outList.add(builds.size());
        }
        return outList;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public List<String> getPerformanceReportList() {
        if (this.performanceReportList == null) {
            this.performanceReportList = new ArrayList<String>(0);
        }
        return this.performanceReportList;
    }

    public void setPerformanceReportList(List<String> performanceReportList) {
        this.performanceReportList = performanceReportList;
    }

    public boolean isTrendVisibleOnProjectDashboard() {
        return this.getPerformanceReportList() != null && this.getPerformanceReportList().size() == 1;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (CONFIGURE_LINK.equals(link)) {
            return this.createUserConfiguration(request);
        }
        if (TRENDREPORT_LINK.equals(link)) {
            return this.createTrendReport(request);
        }
        return null;
    }

    private Object createUserConfiguration(StaplerRequest request) {
        GraphConfigurationDetail graph = new GraphConfigurationDetail(this.project, PLUGIN_NAME, request);
        return graph;
    }

    private Object createTrendReport(StaplerRequest request) {
        String filename = this.getTrendReportFilename(request);
        CategoryDataset dataSet = this.getTrendReportData(request, filename).build();
        TrendReportDetail report = new TrendReportDetail(this.project, PLUGIN_NAME, request, filename, dataSet);
        return report;
    }

    private String getTrendReportFilename(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return performanceReportPosition.getPerformanceReportPosition();
    }

    private DataSetBuilder getTrendReportData(StaplerRequest request, String performanceReportNameFile) {
        DataSetBuilder dataSet = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        List<Integer> buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (nbBuildsToAnalyze <= buildsLimits.get(1) && buildsLimits.get(0) <= nbBuildsToAnalyze) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport report = null;
                report = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (report == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSet.add((Number)Math.round(report.getAverage()), (Comparable)((Object)Messages.ProjectAction_Average()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMedian()), (Comparable)((Object)Messages.ProjectAction_Median()), (Comparable)label);
                dataSet.add((Number)Math.round(report.get90Line()), (Comparable)((Object)Messages.ProjectAction_Line90()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMin()), (Comparable)((Object)Messages.ProjectAction_Minimum()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMax()), (Comparable)((Object)Messages.ProjectAction_Maximum()), (Comparable)label);
                dataSet.add((Number)Math.round(report.errorPercent()), (Comparable)((Object)Messages.ProjectAction_PercentageOfErrors()), (Comparable)label);
                dataSet.add((Number)Math.round(report.countErrors()), (Comparable)((Object)Messages.ProjectAction_Errors()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        return dataSet;
    }
}

