/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.HttpSample;
import hudson.plugins.blazemeter.PerformanceReport;
import hudson.plugins.blazemeter.PerformanceReportParser;
import hudson.plugins.blazemeter.PerformanceReportParserDescriptor;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadReportParser
extends PerformanceReportParser {
    @DataBoundConstructor
    public LoadReportParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.jtl";
    }

    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        PrintStream logger = listener.getLogger();
        for (File f : reports) {
            try {
                SAXParser parser = factory.newSAXParser();
                final PerformanceReport r = new PerformanceReport();
                r.setReportFileName(f.getName());
                logger.println("Performance: Parsing JMeter report file " + f.getName());
                parser.parse(f, new DefaultHandler(){
                    HttpSample currentSample;
                    int counter = 0;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                            HttpSample sample = new HttpSample();
                            sample.setDate(new Date(Long.valueOf(attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp"))));
                            sample.setDuration(Long.valueOf(attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time")));
                            sample.setSuccessful(Boolean.valueOf(attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success")));
                            sample.setUri(attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label"));
                            sample.setHttpCode(attributes.getValue("rc") != null && attributes.getValue("rc").length() <= 3 ? attributes.getValue("rc") : "0");
                            if (this.counter == 0) {
                                this.currentSample = sample;
                            }
                            ++this.counter;
                        }
                    }

                    public void endElement(String uri, String localName, String qName) {
                        if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                            if (this.counter == 1) {
                                try {
                                    r.addSample(this.currentSample);
                                }
                                catch (SAXException e) {
                                    e.printStackTrace();
                                }
                            }
                            --this.counter;
                        }
                    }
                });
                result.add(r);
            }
            catch (ParserConfigurationException e) {
                throw new IOException2("Failed to create parser ", (Throwable)e);
            }
            catch (SAXException e) {
                logger.println("Performance: Failed to parse " + f + ": " + e.getMessage());
            }
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "Test ID";
        }
    }
}

