/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.blazemeter.CookieHandler;
import hudson.plugins.blazemeter.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphConfigurationDetail
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(GraphConfigurationDetail.class.getName());
    public static final String SEPARATOR = ";";
    private int buildCount;
    private String firstDayCount;
    private String lastDayCount;
    private String configType;
    public static final int DEFAULT_COUNT = 0;
    public static final String DEFAULT_DATE = "dd/MM/yyyy";
    public static final String NONE_CONFIG = "NONE";
    public static final String BUILD_CONFIG = "BUILD";
    public static final String DATE_CONFIG = "DATE";
    static DateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public GraphConfigurationDetail(AbstractProject<?, ?> project, String pluginName, StaplerRequest request) {
        String value = GraphConfigurationDetail.createCookieHandler(pluginName).getValue(request.getCookies());
        List<Integer> initializationListResult = this.initializeFrom(value);
        if (!initializationListResult.isEmpty()) {
            File defaultsFile = GraphConfigurationDetail.createDefaultsFile(project, pluginName);
            if (defaultsFile.exists()) {
                String defaultValue = this.readFromDefaultsFile(defaultsFile);
                initializationListResult = this.initializeFrom(defaultValue);
                if (!initializationListResult.isEmpty()) {
                    this.reset(initializationListResult);
                }
            } else {
                this.reset(initializationListResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(StaplerRequest request, StaplerResponse response) {
        try {
            JSONObject formData = request.getSubmittedForm();
            String buildCountString = formData.getString("buildCountString");
            int buildCount = 0;
            if (StringUtils.isNotBlank((String)buildCountString)) {
                buildCount = formData.getInt("buildCountString");
            }
            String firstDayCountString = formData.getString("firstDayCountString");
            String firstDayCount = DEFAULT_DATE;
            if (StringUtils.isNotBlank((String)firstDayCountString)) {
                firstDayCount = formData.getString("firstDayCountString");
            }
            String lastDayCountString = formData.getString("lastDayCountString");
            String lastDayCount = DEFAULT_DATE;
            if (StringUtils.isNotBlank((String)lastDayCountString)) {
                lastDayCount = formData.getString("lastDayCountString");
            }
            String radioConfigType = formData.getString("radioConfigType");
            String configType = NONE_CONFIG;
            if (StringUtils.isNotBlank((String)radioConfigType)) {
                configType = formData.getString("radioConfigType");
            }
            String value = this.serializeToString(configType, buildCount, firstDayCount, lastDayCount);
            this.persistValue(value, request, response);
        }
        catch (JSONException exception) {
            LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
        }
        catch (ServletException exception) {
            LOGGER.log(Level.SEVERE, "Can't process the form data: " + request, exception);
        }
        finally {
            try {
                response.sendRedirect("../");
            }
            catch (IOException exception) {
                LOGGER.log(Level.SEVERE, "Can't redirect", exception);
            }
        }
    }

    public String getDisplayName() {
        return Messages.GraphConfigurationDetail_DisplayName();
    }

    private static CookieHandler createCookieHandler(String cookieName) {
        return new CookieHandler(cookieName);
    }

    protected void persistValue(String value, StaplerRequest request, StaplerResponse response) {
        String buildCount = request.getParameter("buildCount");
        if (buildCount != null) {
            this.setBuildCount(Integer.parseInt(buildCount));
            this.setConfigType(BUILD_CONFIG);
            return;
        }
        Cookie cookie = GraphConfigurationDetail.createCookieHandler("jenkins").create(request.getAncestors(), value);
        response.addCookie(cookie);
    }

    protected String serializeToString(String configType, int buildCount, String firstDayCount, String lastDayCount) {
        return configType + SEPARATOR + buildCount + SEPARATOR + firstDayCount + SEPARATOR + lastDayCount;
    }

    protected static File createDefaultsFile(AbstractProject<?, ?> project, String pluginName) {
        return new File(project.getRootDir(), pluginName + ".txt");
    }

    private List<Integer> initializeFrom(String value) {
        ArrayList<Integer> listErrors = new ArrayList<Integer>(0);
        if (StringUtils.isBlank((String)value)) {
            listErrors.add(-1);
            return listErrors;
        }
        String[] values = StringUtils.split((String)value, (String)SEPARATOR);
        if (values.length != 4) {
            listErrors.add(-1);
            return listErrors;
        }
        this.configType = values[0];
        if (BUILD_CONFIG.compareToIgnoreCase(this.configType) != 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) != 0 && NONE_CONFIG.compareToIgnoreCase(this.configType) != 0) {
            listErrors.add(-1);
        }
        try {
            this.buildCount = Integer.parseInt(values[1]);
        }
        catch (JSONException e) {
            listErrors.add(1);
            e.printStackTrace();
        }
        this.firstDayCount = values[2];
        this.lastDayCount = values[3];
        GregorianCalendar firstDate = null;
        GregorianCalendar lastDate = null;
        if (this.firstDayCount.compareTo(DEFAULT_DATE) == 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) == 0) {
            listErrors.add(2);
        }
        if (this.lastDayCount.compareTo(DEFAULT_DATE) == 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) == 0) {
            listErrors.add(3);
        }
        if (this.firstDayCount.compareTo(DEFAULT_DATE) != 0) {
            try {
                firstDate = GraphConfigurationDetail.getGregorianCalendarFromString(this.firstDayCount);
            }
            catch (IllegalArgumentException e) {
                listErrors.add(2);
                e.printStackTrace();
            }
            catch (ParseException e) {
                listErrors.add(2);
                e.printStackTrace();
            }
        }
        if (this.lastDayCount.compareTo(DEFAULT_DATE) != 0) {
            try {
                lastDate = GraphConfigurationDetail.getGregorianCalendarFromString(this.lastDayCount);
            }
            catch (IllegalArgumentException e) {
                listErrors.add(3);
                e.printStackTrace();
            }
            catch (ParseException e) {
                listErrors.add(3);
                e.printStackTrace();
            }
        }
        if (firstDate != null && lastDate != null && firstDate.after(lastDate)) {
            listErrors.add(2);
            listErrors.add(3);
        }
        if (!listErrors.isEmpty()) {
            Collections.sort(listErrors);
            if ((Integer)listErrors.get(0) == -1) {
                listErrors = new ArrayList(1);
                listErrors.add(-1);
            } else {
                int actualErrorType = 0;
                ArrayList<Integer> realListErrors = new ArrayList<Integer>(0);
                for (Integer typeError : listErrors) {
                    if (actualErrorType == typeError) continue;
                    actualErrorType = typeError;
                    realListErrors.add(typeError);
                }
                listErrors = realListErrors;
            }
        }
        return listErrors;
    }

    public static GregorianCalendar getGregorianCalendarFromString(String dateString) throws ParseException {
        Date date = format.parse(dateString);
        GregorianCalendar outCalendar = new GregorianCalendar();
        outCalendar.setTime(date);
        return outCalendar;
    }

    private void reset(List<Integer> initializationResult) {
        this.configType = NONE_CONFIG;
        for (Integer errorNumber : initializationResult) {
            if (errorNumber == -1) {
                this.buildCount = 0;
                this.firstDayCount = DEFAULT_DATE;
                this.lastDayCount = DEFAULT_DATE;
                continue;
            }
            if (errorNumber == 1) {
                this.buildCount = 0;
                continue;
            }
            if (errorNumber == 2) {
                this.firstDayCount = DEFAULT_DATE;
                continue;
            }
            if (errorNumber != 3) continue;
            this.lastDayCount = DEFAULT_DATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readFromDefaultsFile(File defaultsFile) {
        String defaultValue = "";
        FileInputStream input = null;
        try {
            input = new FileInputStream(defaultsFile);
            defaultValue = IOUtils.toString((InputStream)input);
        }
        catch (IOException exception) {
            IOUtils.closeQuietly((InputStream)input);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return defaultValue;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public void setBuildCount(int buildCount) {
        this.buildCount = buildCount;
    }

    public String getFirstDayCount() {
        return this.firstDayCount;
    }

    public void setFirstDayCount(String firstDayCount) {
        this.firstDayCount = firstDayCount;
    }

    public String getLastDayCount() {
        return this.lastDayCount;
    }

    public void setLastDayCount(String lastDayCount) {
        this.lastDayCount = lastDayCount;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }
}

