/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.plugins.blazemeter.AbstractBlazemeterCredential;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.api.BlazemeterApi;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BlazemeterCredentialImpl
extends AbstractBlazemeterCredential {
    private static final long serialVersionUID = 1L;
    private final Secret apiKey;
    private final String description;

    @DataBoundConstructor
    public BlazemeterCredentialImpl(String apiKey, String description) {
        this.apiKey = Secret.fromString((String)apiKey);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.BlazemeterCredential_DisplayName();
        }

        public ListBoxModel doFillScopeItems() {
            ListBoxModel m = new ListBoxModel();
            m.add(CredentialsScope.GLOBAL.getDisplayName(), CredentialsScope.GLOBAL.toString());
            return m;
        }

        public FormValidation doTestConnection(@QueryParameter(value="apiKey") String userKey) throws MessagingException, IOException, JSONException, ServletException {
            BlazemeterApi bzm = new BlazemeterApi();
            int testCount = bzm.getTestCount(userKey);
            if (testCount < 0) {
                return FormValidation.errorWithMarkup((String)"An error as occurred, check proxy settings");
            }
            if (testCount == 0) {
                return FormValidation.errorWithMarkup((String)"User Key Invalid Or No Available Tests");
            }
            return FormValidation.ok((String)("User Key Valid. " + testCount + " Available Tests"));
        }
    }
}

