/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.validate;

import com.atlassian.annotations.PublicApi;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class ValidationResult {
    private static final ValidationResult VALID = new ValidationResult(Collections.<String>emptyList());
    private final List<String> errorMessages;

    private ValidationResult(@Nonnull List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public static ValidationResult valid() {
        return VALID;
    }

    public static ValidationResult withErrorMessages(List<String> errorMessages) {
        if (errorMessages == null) {
            return ValidationResult.valid();
        }
        return new ValidationResult(errorMessages);
    }

    boolean isValid() {
        return this.errorMessages.isEmpty();
    }

    @Nonnull
    List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

