package com.atlassian.plugin.osgi.hook.rest;

import com.atlassian.plugin.osgi.internal.hook.rest.JaxRsFilterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class RestVersionResolverHook implements ResolverHook {

    private final JaxRsFilterFactory jaxRsFilterFactory;

    public RestVersionResolverHook(JaxRsFilterFactory jaxRsFilterFactory) {
        this.jaxRsFilterFactory = jaxRsFilterFactory;
    }

    @Override
    public void filterResolvable(Collection<BundleRevision> collection) {
    }

    @Override
    public void filterSingletonCollisions(BundleCapability bundleCapability, Collection<BundleCapability> collection) {
    }

    @Override
    public void filterMatches(BundleRequirement bundleRequirement, Collection<BundleCapability> collection) {
        List<BundleCapability> restCapabilities = collection.stream()
                .filter(RestVersionUtils::isJaxRsPackage)
                .collect(Collectors.toList());

        if (restCapabilities.size() > 1) {
            Bundle bundle = bundleRequirement.getRevision().getBundle();
            restCapabilities.stream()
                    //remove everything that doesn't match expected version
                    .filter(jaxRsFilterFactory.getFilter(bundle).negate())
                    .forEach(collection::remove);
        }
    }

    @Override
    public void end() {

    }
}
