package com.atlassian.plugin.osgi.hook;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;

/**
 * Implementation based on stash DMZ impl:
 * <a href="https://stash.atlassian.com/projects/STASH/repos/stash/browse/platform/src/main/java/com/atlassian/stash/internal/osgi/DmzResolverHookFactory.java">DmzResolverHookFactory</a>
 */
public class DmzResolverHookFactory implements ResolverHookFactory {

    private final Set<String> bundledPluginKeys;
    private final Set<String> dmzPackages;

    public DmzResolverHookFactory(PackageScannerConfiguration packageScannerConfig) {
        Objects.requireNonNull(packageScannerConfig, "Configuration required.");
        bundledPluginKeys = packageScannerConfig.getApplicationBundledInternalPlugins();
        dmzPackages = packageScannerConfig.getOsgiDmzPackages();
    }

    @Override
    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new DmzResolverHook(bundledPluginKeys, dmzPackages);
    }
}
