package com.atlassian.plugin.osgi.container.felix;

import org.apache.commons.io.IOUtils;
import org.eclipse.gemini.blueprint.service.importer.support.LocalBundleContextAdvice;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

import java.io.IOException;
import java.io.InputStream;

/**
 * A weaving hook used to intercept a plugin and apply the given implementation of LocalBundleContextAdvice
 * in order to store multiple plugin keys
 *
 */
public class PluginKeyWeaver implements WeavingHook {

    @Override
    public void weave(WovenClass wovenClass) {
        if (wovenClass.getClassName().contains("LocalBundleContextAdvice")) {
            final String name = LocalBundleContextAdvice.class.getName().replace('.', '/') + ".class";
            try (InputStream stream = getClass().getClassLoader().getResourceAsStream(name)) {
                final byte[] val = IOUtils.toByteArray(stream);
                wovenClass.setBytes(val);
                wovenClass.getDynamicImports().add("com.atlassian.plugin");
                wovenClass.getDynamicImports().add("com.atlassian.plugin.osgi.util");
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}
