package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import net.bytebuddy.asm.Advice;
import org.osgi.framework.BundleContext;

public class SheepCtorAdvice {
    @Advice.OnMethodExit
    public static void afterCtor(
            @Advice.FieldValue(value = "pluginKey", readOnly = false) String pluginKey,
            @Advice.FieldValue("context") BundleContext context) {
        pluginKey = OsgiHeaderUtil.getPluginKey(context.getBundle());
        System.out.println("============ pluginKey ctor: " + pluginKey);
//        pluginKey = "xxxx";
    }
}
