package com.atlassian.plugin.osgi.container.felix;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

import static net.bytebuddy.matcher.ElementMatchers.isConstructor;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * A weaving hook used to intercept a plugin and apply the given implementation of LocalBundleContextAdvice
 * in order to store multiple plugin keys
 *
 */
public class PluginKeyWeaver implements WeavingHook {
    private Class<?> targetClass = PluginKeyWeaver.class.getClassLoader().loadClass("org.eclipse.gemini.blueprint.service.importer.support.LocalBundleContextAdvice");
//    private Class<?> targetClass = Sheep.class;

    public PluginKeyWeaver() throws ClassNotFoundException {}

    @Override
    public void weave(WovenClass wovenClass) {
        if (wovenClass.getClassName().equals(targetClass.getName())) {
//            final TypePool typePool = TypePool.Default.of(wovenClass.getBundleWiring().getClassLoader());
//            final TypeDescription def = typePool.describe(wovenClass.getClassName()).resolve();
//            final ClassFileLocator locator = ClassFileLocator.Simple.of(wovenClass.getClassName(), wovenClass.getBytes());

            final byte[] target = new ByteBuddy()
                    .rebase(targetClass)
                    .defineField("pluginKey", String.class)
                    .visit(Advice.to(SheepCtorAdvice.class).on(isConstructor()))
                    .visit(Advice.to(SheepAdvice.class).on(named("invoke")))
                    .make()
                    .getBytes();
            wovenClass.setBytes(target);
//            final String name = LocalBundleContextAdvice.class.getName().replace('.', '/') + ".class";
//            try (InputStream stream = getClass().getClassLoader().getResourceAsStream(name)) {
//                final byte[] val = IOUtils.toByteArray(stream);
//                wovenClass.setBytes(val);
                wovenClass.getDynamicImports().add("com.atlassian.plugin.osgi.container.felix");
//                wovenClass.getDynamicImports().add("com.atlassian.plugin.osgi.util");
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
        }
    }
}
