package com.atlassian.plugin.osgi.container.felix;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectJWeavingHook implements WeavingHook {

    static Logger logger = LoggerFactory.getLogger(AspectJWeavingHook.class);

    protected ConcurrentMap<ClassLoader, ClassLoaderWeavingAdaptor> adaptorMap = new ConcurrentHashMap<>();

    protected ClassLoaderWeavingAdaptor ensureAdaptor(BundleWiring wiring) {
        ClassLoader key = wiring.getClassLoader();
        return adaptorMap.computeIfAbsent(key, loader -> {
            logger.info("register loader: {}", loader);
            ClassLoaderWeavingAdaptor adaptor = new ClassLoaderWeavingAdaptor();
            AspectContext context = new AspectContext(wiring);
            adaptor.initialize(loader, context);
            return adaptor;
        });
    }

    @Override
    public void weave(WovenClass woven) {
        System.out.println("========= aspectj");

        try {
            String name = woven.getClassName();
            BundleWiring wiring = woven.getBundleWiring();
            ClassLoaderWeavingAdaptor adaptor = ensureAdaptor(wiring);
            final byte[] source = woven.getBytes();
            final byte[] target;
            // aspectj is single-threaded
            synchronized (adaptor) {
                target = adaptor.weaveClass(name, source);
            }
            woven.setBytes(target);
            if (source != target) {
                logger.info("woven class: {}", name);
            }
        } catch (Throwable e) {
            throw new Error(e);
        }
    }

}