package com.atlassian.plugin.osgi.container.felix;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.osgi.framework.wiring.BundleWiring;

public class AspectContext extends DefaultWeavingContext {

    protected BundleWiring wiring;

    protected volatile List<Definition> definitionList;

    protected String rootConfig = "META-INF/aop.xml";

    public AspectContext(BundleWiring wiring) {
        super(wiring.getClassLoader());
        this.wiring = wiring;
    }

    @Override
    public String getId() {
        return getClassLoaderName();
    }

    @Override
    public String getClassLoaderName() {
        return wiring.getRevision().getSymbolicName();
    }

    @Override
    public List<Definition> getDefinitions(final ClassLoader loader, final WeavingAdaptor adaptor) {
        if (definitionList == null) {
            definitionList = definitionList(loader, rootConfig);
        }
        return definitionList;
    }

    private static List<Definition> definitionList(ClassLoader loader, String resource) {
        Map<URL, Definition> definitionMap = new HashMap<>();
        try {
//            Enumeration<URL> resourcezList = loader.getResources(resource);
            Enumeration<URL> resourcezList = AspectContext.class.getClassLoader().getResources(resource);
            while (resourcezList.hasMoreElements()) {
                URL url = resourcezList.nextElement();
                Definition definition = DocumentParser.parse(url);
                definitionMap.put(url, definition);
            }
            return new ArrayList<>(definitionMap.values());
        } catch (Exception e) {
            throw new Error(e);
        }
    }

}