/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class MigrateMethodCallChangeArgumentType
extends Recipe {
    @Option(displayName="From method pattern", description="From method pattern", example="com.atlassian.sal.api.usersettings.UserSettingsService getUserSettings(String)")
    @NonNull
    @JsonProperty(value="fromMethodPattern")
    private final String fromMethodPattern;
    @Option(displayName="New argument pattern", description="New argument pattern", example="new UserKey(#{any()})")
    @NonNull
    @JsonProperty(value="newArgumentPattern")
    private final String newArgumentPattern;
    @Option(displayName="Import class", description="Import class", example="com.atlassian.sal.api.user.UserKey")
    @NonNull
    @JsonProperty(value="newImports")
    private final String[] newImports;
    @Option(displayName="Remove imports", description="Remove imports", example="com.atlassian.sal.api.user.UserKey")
    @Nullable
    @JsonProperty(value="removeImports")
    private final String[] removeImports;
    private final MethodMatcher FROM_METHOD_MATCHER;

    public MigrateMethodCallChangeArgumentType(@JsonProperty(value="fromMethodPattern") @NonNull String fromMethodPattern, @JsonProperty(value="newArgumentPattern") @NonNull String newArgumentPattern, @JsonProperty(value="newImports") @NonNull String[] newImports, @JsonProperty(value="removeImports") @Nullable String[] removeImports) {
        this.fromMethodPattern = fromMethodPattern;
        this.newArgumentPattern = newArgumentPattern;
        this.newImports = newImports;
        this.removeImports = removeImports;
        this.FROM_METHOD_MATCHER = new MethodMatcher(fromMethodPattern);
    }

    public String getDisplayName() {
        return "Switch call argument from one to another";
    }

    public String getDescription() {
        return "Use to change argument in a method call.";
    }

    public Set<String> getTags() {
        return Collections.singleton("atlassian-dc");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(this.FROM_METHOD_MATCHER)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MigrateMethodCallChangeArgumentType.this.FROM_METHOD_MATCHER.matches((MethodCall)m)) {
                    m = (J.MethodInvocation)JavaTemplate.builder((String)MigrateMethodCallChangeArgumentType.this.newArgumentPattern).contextSensitive().imports(MigrateMethodCallChangeArgumentType.this.newImports).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                }
                Arrays.stream(MigrateMethodCallChangeArgumentType.this.newImports).forEach(i -> this.maybeAddImport((String)i, false));
                Arrays.stream(MigrateMethodCallChangeArgumentType.this.removeImports).forEach(arg_0 -> (this).maybeRemoveImport(arg_0));
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }

    public String getFromMethodPattern() {
        return this.fromMethodPattern;
    }

    public String getNewArgumentPattern() {
        return this.newArgumentPattern;
    }

    public String[] getNewImports() {
        return this.newImports;
    }

    public String[] getRemoveImports() {
        return this.removeImports;
    }

    public MethodMatcher getFROM_METHOD_MATCHER() {
        return this.FROM_METHOD_MATCHER;
    }

    public String toString() {
        return "MigrateMethodCallChangeArgumentType(fromMethodPattern=" + this.getFromMethodPattern() + ", newArgumentPattern=" + this.getNewArgumentPattern() + ", newImports=" + Arrays.deepToString(this.getNewImports()) + ", removeImports=" + Arrays.deepToString(this.getRemoveImports()) + ", FROM_METHOD_MATCHER=" + this.getFROM_METHOD_MATCHER() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateMethodCallChangeArgumentType)) {
            return false;
        }
        MigrateMethodCallChangeArgumentType other = (MigrateMethodCallChangeArgumentType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fromMethodPattern = this.getFromMethodPattern();
        String other$fromMethodPattern = other.getFromMethodPattern();
        if (this$fromMethodPattern == null ? other$fromMethodPattern != null : !this$fromMethodPattern.equals(other$fromMethodPattern)) {
            return false;
        }
        String this$newArgumentPattern = this.getNewArgumentPattern();
        String other$newArgumentPattern = other.getNewArgumentPattern();
        if (this$newArgumentPattern == null ? other$newArgumentPattern != null : !this$newArgumentPattern.equals(other$newArgumentPattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNewImports(), other.getNewImports())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRemoveImports(), other.getRemoveImports())) {
            return false;
        }
        MethodMatcher this$FROM_METHOD_MATCHER = this.getFROM_METHOD_MATCHER();
        MethodMatcher other$FROM_METHOD_MATCHER = other.getFROM_METHOD_MATCHER();
        return !(this$FROM_METHOD_MATCHER == null ? other$FROM_METHOD_MATCHER != null : !this$FROM_METHOD_MATCHER.equals(other$FROM_METHOD_MATCHER));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrateMethodCallChangeArgumentType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromMethodPattern = this.getFromMethodPattern();
        result = result * 59 + ($fromMethodPattern == null ? 43 : $fromMethodPattern.hashCode());
        String $newArgumentPattern = this.getNewArgumentPattern();
        result = result * 59 + ($newArgumentPattern == null ? 43 : $newArgumentPattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNewImports());
        result = result * 59 + Arrays.deepHashCode(this.getRemoveImports());
        MethodMatcher $FROM_METHOD_MATCHER = this.getFROM_METHOD_MATCHER();
        result = result * 59 + ($FROM_METHOD_MATCHER == null ? 43 : $FROM_METHOD_MATCHER.hashCode());
        return result;
    }
}

