/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes;

import com.atlassian.platform.recipes.ChangeVariableType;
import com.atlassian.platform.recipes.model.ArgumentTypeRefactor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ReplaceCompositeArgumentMethodInvocationVisitor
extends JavaIsoVisitor<ExecutionContext> {
    ArgumentTypeRefactor firstLevelRefactor;
    ArgumentTypeRefactor secondLevelRefactor;

    public ReplaceCompositeArgumentMethodInvocationVisitor(ArgumentTypeRefactor firstLevelRefactor, ArgumentTypeRefactor secondLevelRefactor) {
        this.firstLevelRefactor = firstLevelRefactor;
        this.secondLevelRefactor = secondLevelRefactor;
    }

    protected Expression transformArg(Expression expressionToRefactor, ArgumentTypeRefactor firstLevel, ArgumentTypeRefactor secondLevel) {
        if (firstLevel == null || expressionToRefactor == null || !firstLevel.matchesType(expressionToRefactor.getType())) {
            return expressionToRefactor;
        }
        if (expressionToRefactor instanceof J.MethodInvocation) {
            return this.refactorMethodInvocation((J.MethodInvocation)expressionToRefactor, firstLevel, secondLevel);
        }
        if (expressionToRefactor instanceof J.Identifier) {
            J.Identifier identifier = (J.Identifier)expressionToRefactor;
            this.doAfterVisit((TreeVisitor)new ChangeVariableType(identifier.getSimpleName(), firstLevel, secondLevel));
            return this.transformIdentifier(identifier, firstLevel);
        }
        return expressionToRefactor;
    }

    @NotNull
    private J.MethodInvocation refactorMethodInvocation(J.MethodInvocation expressionToRefactor, ArgumentTypeRefactor firstLevel, ArgumentTypeRefactor secondLevel) {
        J.MethodInvocation expToRefactor = expressionToRefactor;
        JavaType.Method toTypeMethodType = expressionToRefactor.getMethodType();
        toTypeMethodType = toTypeMethodType.withReturnType(firstLevel.getTo()).withDeclaringType(firstLevel.getToTypeFullyQualified());
        J.Identifier toSelect = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), firstLevel.getToSimpleName(), firstLevel.getTo(), null);
        J.MethodInvocation resultingExpression = expToRefactor.withSelect((Expression)toSelect).withArguments(ListUtils.map((List)expToRefactor.getArguments(), arg -> this.transformArg((Expression)arg, secondLevel, null))).withMethodType(toTypeMethodType);
        return resultingExpression;
    }

    J.Identifier transformIdentifier(J.Identifier identifier, ArgumentTypeRefactor transformationToApply) {
        JavaType.Variable toFieldType = identifier.getFieldType();
        toFieldType = toFieldType.withType((JavaType)transformationToApply.getToTypeFullyQualified()).withOwner(transformationToApply.transformIfMatches(toFieldType.getOwner()));
        identifier = identifier.withType((JavaType)toFieldType).withFieldType(toFieldType);
        return identifier;
    }
}

