/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes.rest.tov2;

import com.atlassian.platform.recipes.model.SpringConfigType;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PathUtils;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class MigrateCorsModuleDescriptor
extends ScanningRecipe<ProjectShapeAccumulator> {
    private static final String ATLASSIAN_PLUGIN_ELEMENT = "atlassian-plugin";
    private static final String CORS_ELEMENT = "cors-defaults";
    private static final String BEANS_ELEMENT = "beans";

    public String getDisplayName() {
        return "Migrate from Cors module Descriptor";
    }

    public String getDescription() {
        return "Migrate from Cors module Descriptor.";
    }

    public ProjectShapeAccumulator getInitialValue(ExecutionContext ctx) {
        return new ProjectShapeAccumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(ProjectShapeAccumulator acc) {
        return new SeekCorsModuleDescriptorVisitor(acc);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(ProjectShapeAccumulator acc) {
        if (!acc.corsDefaultOverriden) {
            return TreeVisitor.noop();
        }
        return new MakeChangesToMultipleFilesVisitor(acc);
    }

    private static boolean isAtlassianPluginXml(SourceFile sourceFile) {
        return PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/atlassian-plugin.xml");
    }

    private static boolean isSpringXmlConfig(SourceFile sourceFile) {
        return PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"src/main/resources/META-INF/spring/*.xml");
    }

    public String toString() {
        return "MigrateCorsModuleDescriptor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateCorsModuleDescriptor)) {
            return false;
        }
        MigrateCorsModuleDescriptor other = (MigrateCorsModuleDescriptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrateCorsModuleDescriptor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static class ProjectShapeAccumulator {
        boolean corsDefaultOverriden;
        String keyToExport;
        String classToExport;
        SpringConfigType type = SpringConfigType.OSGI_SPRING;

        ProjectShapeAccumulator() {
        }

        public boolean isCorsDefaultOverriden() {
            return this.corsDefaultOverriden;
        }

        public String getKeyToExport() {
            return this.keyToExport;
        }

        public String getClassToExport() {
            return this.classToExport;
        }

        public SpringConfigType getType() {
            return this.type;
        }
    }

    static class SeekCorsModuleDescriptorVisitor
    extends XmlIsoVisitor<ExecutionContext> {
        private final ProjectShapeAccumulator acc;

        SeekCorsModuleDescriptorVisitor(ProjectShapeAccumulator acc) {
            this.acc = acc;
        }

        public boolean isAcceptable(SourceFile sourceFile, @NotNull ExecutionContext executionContext) {
            return MigrateCorsModuleDescriptor.isAtlassianPluginXml(sourceFile) || MigrateCorsModuleDescriptor.isSpringXmlConfig(sourceFile);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Xml.Document visitDocument(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Xml.Document document, @NotNull ExecutionContext ctx) {
            Xml.Document d = super.visitDocument(document, (Object)ctx);
            Xml.Tag root = d.getRoot();
            if (MigrateCorsModuleDescriptor.isAtlassianPluginXml((SourceFile)document) && root.getName().equals(MigrateCorsModuleDescriptor.ATLASSIAN_PLUGIN_ELEMENT)) {
                if (root.getChild(MigrateCorsModuleDescriptor.CORS_ELEMENT).isPresent()) {
                    Xml.Tag corsElem = (Xml.Tag)root.getChild(MigrateCorsModuleDescriptor.CORS_ELEMENT).get();
                    String classToExport = corsElem.getAttributes().stream().filter(a -> a.getKeyAsString().equals("class")).findFirst().orElseThrow().getValueAsString();
                    String key = corsElem.getAttributes().stream().filter(a -> a.getKeyAsString().equals("key")).findFirst().orElseThrow().getValueAsString();
                    this.acc.corsDefaultOverriden = true;
                    this.acc.keyToExport = key;
                    this.acc.classToExport = classToExport;
                }
                if (root.getChild("component").isPresent() || root.getChild("component-import").isPresent() || root.getChild("module-type").isPresent()) {
                    this.acc.type = SpringConfigType.SPRING_1;
                }
            }
            if (MigrateCorsModuleDescriptor.isSpringXmlConfig((SourceFile)document)) {
                if (root.getChild("atlassian-scanner").isPresent()) {
                    this.acc.type = SpringConfigType.SPRING_2;
                } else if (root.getChild("osgi:service").isPresent() || root.getChild("osgi:reference").isPresent()) {
                    this.acc.type = SpringConfigType.OSGI_SPRING;
                } else if (root.getChild("context:annotation-config").isPresent()) {
                    this.acc.type = SpringConfigType.JAVA_CONFIG;
                }
            }
            return d;
        }
    }

    static class MakeChangesToMultipleFilesVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final ProjectShapeAccumulator acc;

        MakeChangesToMultipleFilesVisitor(ProjectShapeAccumulator acc) {
            this.acc = acc;
        }

        @Nullable
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof Xml.Document) {
                return new MakeChangesToXmlFiles(this.acc).visit(tree, ctx);
            }
            return tree;
        }
    }

    static class MakeChangesToXmlFiles
    extends XmlIsoVisitor<ExecutionContext> {
        private final ProjectShapeAccumulator acc;

        MakeChangesToXmlFiles(ProjectShapeAccumulator acc) {
            this.acc = acc;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Xml.Document visitDocument(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Xml.Document document, @NotNull ExecutionContext ctx) {
            Xml.Document d = super.visitDocument(document, (Object)ctx);
            Xml.Tag root = d.getRoot();
            if (MigrateCorsModuleDescriptor.isAtlassianPluginXml((SourceFile)document) && root.getName().equals(MigrateCorsModuleDescriptor.ATLASSIAN_PLUGIN_ELEMENT) && root.getChild(MigrateCorsModuleDescriptor.CORS_ELEMENT).isPresent()) {
                Xml.Tag corsElement = (Xml.Tag)root.getChild(MigrateCorsModuleDescriptor.CORS_ELEMENT).get();
                this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)corsElement, true));
                if (this.acc.type == SpringConfigType.SPRING_1) {
                    String corsExportServiceStr = String.format("<component key=\"%s\" class=\"%s\" public=\"true\">\n  <interface>com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults</interface>\n</component>\n", this.acc.keyToExport, this.acc.classToExport);
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)corsExportServiceStr)));
                }
            }
            if (this.acc.type == SpringConfigType.OSGI_SPRING && MigrateCorsModuleDescriptor.isSpringXmlConfig((SourceFile)document) && root.getName().equals(MigrateCorsModuleDescriptor.BEANS_ELEMENT)) {
                String beanDeclrStr = String.format("<bean name=\"%s\" class=\"%s\"/>", this.acc.keyToExport, this.acc.classToExport);
                String serviceExportStr = String.format("<osgi:service id=\"%sService\" interface=\"com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults\" ref=\"%s\"/>\n", this.acc.keyToExport, this.acc.keyToExport);
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)beanDeclrStr)));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)serviceExportStr)));
            }
            return d;
        }
    }

    static class InsertMethodsToConfigVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final ProjectShapeAccumulator acc;

        public InsertMethodsToConfigVisitor(ProjectShapeAccumulator acc) {
            this.acc = acc;
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            return super.visitCompilationUnit(cu, (Object)executionContext);
        }
    }
}

