/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes.rest.tov2;

import java.util.Comparator;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class AddInjectAnnotationToResourceConstructor
extends Recipe {
    public String getDisplayName() {
        return "Add javax.inject.Inject annotation to rest resource class constructor";
    }

    public String getDescription() {
        return "Add javax.inject.Inject annotation to rest resource class constructor.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ResourceClassVisitor();
    }

    public class ResourceClassVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String INJECT_PKG = "javax.inject";
        private static final String INJECT_SIMPLE_NAME = "Inject";
        private static final String INJECT_IMPORT = "javax.inject.Inject";
        private static final String INJECT_ANNOTATION = "@Inject";
        private static final String IS_REST_RESOURCE_CLASS = "rest_resource_class";
        private static final String REST_PATH_ANNOTATION = "Path";

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
            if (this.isRestResourceClass(classDecl)) {
                this.getCursor().putMessage(IS_REST_RESOURCE_CLASS, (Object)true);
            }
            return super.visitClassDeclaration(classDecl, (Object)context);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext executionContext) {
            Cursor classCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            if (!((Boolean)classCursor.getMessage(IS_REST_RESOURCE_CLASS, (Object)false)).booleanValue()) {
                return methodDeclaration;
            }
            if (!methodDeclaration.hasModifier(J.Modifier.Type.Public) || !methodDeclaration.isConstructor() || methodDeclaration.isAbstract()) {
                return methodDeclaration;
            }
            if (methodDeclaration.getLeadingAnnotations().stream().anyMatch(annotation -> annotation.getSimpleName().equals(INJECT_SIMPLE_NAME))) {
                return methodDeclaration;
            }
            return this.addInjectAnnotation(methodDeclaration);
        }

        private J.MethodDeclaration addInjectAnnotation(J.MethodDeclaration methodDeclaration) {
            this.maybeAddImport(INJECT_IMPORT);
            JavaTemplate template = JavaTemplate.builder((String)INJECT_ANNOTATION).imports(new String[]{INJECT_IMPORT}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package javax.inject; public @interface Inject {}"})).build();
            return (J.MethodDeclaration)template.apply(this.updateCursor((Tree)methodDeclaration), methodDeclaration.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
        }

        private boolean isRestResourceClass(J.ClassDeclaration classDecl) {
            return classDecl.getLeadingAnnotations().stream().anyMatch(annotation -> annotation.getSimpleName().equals(REST_PATH_ANNOTATION));
        }
    }
}

