/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes;

import com.atlassian.platform.recipes.ReplaceCompositeArgumentMethodInvocationVisitor;
import com.atlassian.platform.recipes.model.ArgumentTypeRefactor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class ReplaceConstructorArgument
extends Recipe {
    @Option(displayName="Fully Qualified Class Name", description="A fully qualified class name indicating class to which constructor to refactor", example="com.atlassian.sal.api.features.EnabledDarkFeatures")
    @NonNull
    @JsonProperty(value="refactorCallsToClassName")
    private final String refactorCallsToClassName;
    @Option(displayName="Type to refactor from", description="First level type to refactor from", example="com.google.common.collect.ImmutableMap")
    @NonNull
    @JsonProperty(value="firstLevelRefactorTypeFrom")
    private final String firstLevelRefactorTypeFrom;
    @Option(displayName="Type to refactor to", description="First level type to refactor to", example="java.util.Map")
    @NonNull
    @JsonProperty(value="firstLevelRefactorTypeTo")
    private final String firstLevelRefactorTypeTo;
    @Option(displayName="Type to refactor from - second level", description="Second level type to refactor from - aka for a constructor we want to refactor from that expects Map<String, Set<>>, Map will be first level, Set will be second level", example="com.google.common.collect.ImmutableSet")
    @NonNull
    @JsonProperty(value="secondLevelRefactorTypeFrom")
    private final String secondLevelRefactorTypeFrom;
    @Option(displayName="Type to refactor to - second level", description="Second level type to refactor to - aka for a constructor we want to refactor to signature that expects Map<String, Set<>>, Map will be first level, Set will be second level", example="java.util.Set")
    @NonNull
    @JsonProperty(value="secondLevelRefactorTypeTo")
    private final String secondLevelRefactorTypeTo;

    public String getDisplayName() {
        return "Replace constructor parameter types";
    }

    public String getDescription() {
        return "Constructor Argument refactor.";
    }

    public Set<String> getTags() {
        return Collections.singleton("atlassian-dc");
    }

    @JsonCreator
    public ReplaceConstructorArgument(@JsonProperty(value="refactorCallsToClassName") @NonNull String refactorCallsToClassName, @JsonProperty(value="firstLevelRefactorTypeFrom") @NonNull String firstLevelRefactorTypeFrom, @JsonProperty(value="firstLevelRefactorTypeTo") @NonNull String firstLevelRefactorTypeTo, @JsonProperty(value="secondLevelRefactorTypeFrom") @NonNull String secondLevelRefactorTypeFrom, @JsonProperty(value="secondLevelRefactorTypeTo") @NonNull String secondLevelRefactorTypeTo) {
        this.refactorCallsToClassName = refactorCallsToClassName;
        this.firstLevelRefactorTypeFrom = firstLevelRefactorTypeFrom;
        this.firstLevelRefactorTypeTo = firstLevelRefactorTypeTo;
        this.secondLevelRefactorTypeFrom = secondLevelRefactorTypeFrom;
        this.secondLevelRefactorTypeTo = secondLevelRefactorTypeTo;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(this.refactorCallsToClassName + " <constructor>(..)"), new UsesType(this.firstLevelRefactorTypeFrom, Boolean.valueOf(true))});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new DeclaredVariablesInClassContextVisitor());
    }

    public String getRefactorCallsToClassName() {
        return this.refactorCallsToClassName;
    }

    public String getFirstLevelRefactorTypeFrom() {
        return this.firstLevelRefactorTypeFrom;
    }

    public String getFirstLevelRefactorTypeTo() {
        return this.firstLevelRefactorTypeTo;
    }

    public String getSecondLevelRefactorTypeFrom() {
        return this.secondLevelRefactorTypeFrom;
    }

    public String getSecondLevelRefactorTypeTo() {
        return this.secondLevelRefactorTypeTo;
    }

    public String toString() {
        return "ReplaceConstructorArgument(refactorCallsToClassName=" + this.getRefactorCallsToClassName() + ", firstLevelRefactorTypeFrom=" + this.getFirstLevelRefactorTypeFrom() + ", firstLevelRefactorTypeTo=" + this.getFirstLevelRefactorTypeTo() + ", secondLevelRefactorTypeFrom=" + this.getSecondLevelRefactorTypeFrom() + ", secondLevelRefactorTypeTo=" + this.getSecondLevelRefactorTypeTo() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceConstructorArgument)) {
            return false;
        }
        ReplaceConstructorArgument other = (ReplaceConstructorArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$refactorCallsToClassName = this.getRefactorCallsToClassName();
        String other$refactorCallsToClassName = other.getRefactorCallsToClassName();
        if (this$refactorCallsToClassName == null ? other$refactorCallsToClassName != null : !this$refactorCallsToClassName.equals(other$refactorCallsToClassName)) {
            return false;
        }
        String this$firstLevelRefactorTypeFrom = this.getFirstLevelRefactorTypeFrom();
        String other$firstLevelRefactorTypeFrom = other.getFirstLevelRefactorTypeFrom();
        if (this$firstLevelRefactorTypeFrom == null ? other$firstLevelRefactorTypeFrom != null : !this$firstLevelRefactorTypeFrom.equals(other$firstLevelRefactorTypeFrom)) {
            return false;
        }
        String this$firstLevelRefactorTypeTo = this.getFirstLevelRefactorTypeTo();
        String other$firstLevelRefactorTypeTo = other.getFirstLevelRefactorTypeTo();
        if (this$firstLevelRefactorTypeTo == null ? other$firstLevelRefactorTypeTo != null : !this$firstLevelRefactorTypeTo.equals(other$firstLevelRefactorTypeTo)) {
            return false;
        }
        String this$secondLevelRefactorTypeFrom = this.getSecondLevelRefactorTypeFrom();
        String other$secondLevelRefactorTypeFrom = other.getSecondLevelRefactorTypeFrom();
        if (this$secondLevelRefactorTypeFrom == null ? other$secondLevelRefactorTypeFrom != null : !this$secondLevelRefactorTypeFrom.equals(other$secondLevelRefactorTypeFrom)) {
            return false;
        }
        String this$secondLevelRefactorTypeTo = this.getSecondLevelRefactorTypeTo();
        String other$secondLevelRefactorTypeTo = other.getSecondLevelRefactorTypeTo();
        return !(this$secondLevelRefactorTypeTo == null ? other$secondLevelRefactorTypeTo != null : !this$secondLevelRefactorTypeTo.equals(other$secondLevelRefactorTypeTo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceConstructorArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $refactorCallsToClassName = this.getRefactorCallsToClassName();
        result = result * 59 + ($refactorCallsToClassName == null ? 43 : $refactorCallsToClassName.hashCode());
        String $firstLevelRefactorTypeFrom = this.getFirstLevelRefactorTypeFrom();
        result = result * 59 + ($firstLevelRefactorTypeFrom == null ? 43 : $firstLevelRefactorTypeFrom.hashCode());
        String $firstLevelRefactorTypeTo = this.getFirstLevelRefactorTypeTo();
        result = result * 59 + ($firstLevelRefactorTypeTo == null ? 43 : $firstLevelRefactorTypeTo.hashCode());
        String $secondLevelRefactorTypeFrom = this.getSecondLevelRefactorTypeFrom();
        result = result * 59 + ($secondLevelRefactorTypeFrom == null ? 43 : $secondLevelRefactorTypeFrom.hashCode());
        String $secondLevelRefactorTypeTo = this.getSecondLevelRefactorTypeTo();
        result = result * 59 + ($secondLevelRefactorTypeTo == null ? 43 : $secondLevelRefactorTypeTo.hashCode());
        return result;
    }

    private class DeclaredVariablesInClassContextVisitor
    extends ReplaceCompositeArgumentMethodInvocationVisitor {
        TypeMatcher classContextMatcher;
        boolean isTestClass;

        DeclaredVariablesInClassContextVisitor() {
            super(new ArgumentTypeRefactor(ReplaceConstructorArgument.this.firstLevelRefactorTypeFrom, ReplaceConstructorArgument.this.firstLevelRefactorTypeTo), new ArgumentTypeRefactor(ReplaceConstructorArgument.this.secondLevelRefactorTypeFrom, ReplaceConstructorArgument.this.secondLevelRefactorTypeTo));
            this.classContextMatcher = new TypeMatcher(ReplaceConstructorArgument.this.refactorCallsToClassName);
            this.isTestClass = false;
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            if (this.isTestClass(cu = super.visitCompilationUnit(cu, (Object)executionContext))) {
                this.isTestClass = true;
                this.doAfterVisit(new ChangeType(ReplaceConstructorArgument.this.firstLevelRefactorTypeFrom, this.firstLevelRefactor.getToSimpleName(), Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType(ReplaceConstructorArgument.this.secondLevelRefactorTypeFrom, this.secondLevelRefactor.getToSimpleName(), Boolean.valueOf(true)).getVisitor());
            }
            return cu;
        }

        private boolean isTestClass(J.CompilationUnit cs) {
            TypeMatcher junit4 = new TypeMatcher("org.junit.Test");
            TypeMatcher junit5 = new TypeMatcher("org.junit.jupiter.api.Test");
            if (cs.getSourcePath().toString().endsWith("Test.java")) {
                return true;
            }
            for (JavaType type : cs.getTypesInUse().getTypesInUse()) {
                if (!junit4.matches(type) && !junit5.matches(type)) continue;
                return true;
            }
            return false;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            newClass = super.visitNewClass(newClass, (Object)executionContext);
            if (this.isTestClass || !this.classContextMatcher.matches(newClass.getType())) {
                return newClass;
            }
            this.maybeAddImport(this.firstLevelRefactor.getToTypeFullyQualified().getFullyQualifiedName(), false);
            this.maybeAddImport(this.secondLevelRefactor.getToTypeFullyQualified().getFullyQualifiedName(), true);
            this.maybeRemoveImport(this.firstLevelRefactor.getFromTypeFullyQualified());
            this.maybeRemoveImport(this.secondLevelRefactor.getFromTypeFullyQualified());
            List moddedArguments = ListUtils.map((List)newClass.getArguments(), arg -> this.transformArg((Expression)arg, this.firstLevelRefactor, this.secondLevelRefactor));
            JavaType.Method moddedConstructorType = newClass.getConstructorType();
            List moddedConstructorTypes = ListUtils.map((List)moddedConstructorType.getParameterTypes(), param -> this.firstLevelRefactor.transformIfMatches((JavaType)param));
            moddedConstructorType = moddedConstructorType.withParameterTypes(moddedConstructorTypes);
            newClass = newClass.withConstructorType(moddedConstructorType).withArguments(moddedArguments);
            return newClass;
        }
    }
}

