/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class MigrateMethodCallSameArgument
extends Recipe {
    @Option(displayName="From method pattern", description="From method pattern", example="com.atlassian.sal.api.features.FeatureKeyScopePredicate apply(FeatureKeyScope)")
    @NonNull
    @JsonProperty(value="fromMethodPattern")
    private final String fromMethodPattern;
    @Option(displayName="To method call", description="Simple method name", example="test")
    @NonNull
    @JsonProperty(value="toMethodSimpleName")
    private final String toMethodSimpleName;
    private final MethodMatcher FROM_METHOD_MATCHER;

    public String getDisplayName() {
        return "Switch call from one to another";
    }

    public String getDescription() {
        return "Use to change method call from one to another, but only if arguments stay same.";
    }

    public MigrateMethodCallSameArgument(@JsonProperty(value="fromMethodPattern") @NonNull String fromMethodPattern, @JsonProperty(value="toMethodSimpleName") @NonNull String toMethodSimpleName) {
        this.fromMethodPattern = fromMethodPattern;
        this.toMethodSimpleName = toMethodSimpleName;
        this.FROM_METHOD_MATCHER = new MethodMatcher(fromMethodPattern);
    }

    public Set<String> getTags() {
        return Collections.singleton("atlassian-dc");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(this.FROM_METHOD_MATCHER)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MigrateMethodCallSameArgument.this.FROM_METHOD_MATCHER.matches((MethodCall)m)) {
                    m = m.withName(m.getName().withSimpleName(MigrateMethodCallSameArgument.this.toMethodSimpleName));
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}").contextSensitive().build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }

    public String getFromMethodPattern() {
        return this.fromMethodPattern;
    }

    public String getToMethodSimpleName() {
        return this.toMethodSimpleName;
    }

    public MethodMatcher getFROM_METHOD_MATCHER() {
        return this.FROM_METHOD_MATCHER;
    }

    public String toString() {
        return "MigrateMethodCallSameArgument(fromMethodPattern=" + this.getFromMethodPattern() + ", toMethodSimpleName=" + this.getToMethodSimpleName() + ", FROM_METHOD_MATCHER=" + this.getFROM_METHOD_MATCHER() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateMethodCallSameArgument)) {
            return false;
        }
        MigrateMethodCallSameArgument other = (MigrateMethodCallSameArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fromMethodPattern = this.getFromMethodPattern();
        String other$fromMethodPattern = other.getFromMethodPattern();
        if (this$fromMethodPattern == null ? other$fromMethodPattern != null : !this$fromMethodPattern.equals(other$fromMethodPattern)) {
            return false;
        }
        String this$toMethodSimpleName = this.getToMethodSimpleName();
        String other$toMethodSimpleName = other.getToMethodSimpleName();
        if (this$toMethodSimpleName == null ? other$toMethodSimpleName != null : !this$toMethodSimpleName.equals(other$toMethodSimpleName)) {
            return false;
        }
        MethodMatcher this$FROM_METHOD_MATCHER = this.getFROM_METHOD_MATCHER();
        MethodMatcher other$FROM_METHOD_MATCHER = other.getFROM_METHOD_MATCHER();
        return !(this$FROM_METHOD_MATCHER == null ? other$FROM_METHOD_MATCHER != null : !this$FROM_METHOD_MATCHER.equals(other$FROM_METHOD_MATCHER));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrateMethodCallSameArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromMethodPattern = this.getFromMethodPattern();
        result = result * 59 + ($fromMethodPattern == null ? 43 : $fromMethodPattern.hashCode());
        String $toMethodSimpleName = this.getToMethodSimpleName();
        result = result * 59 + ($toMethodSimpleName == null ? 43 : $toMethodSimpleName.hashCode());
        MethodMatcher $FROM_METHOD_MATCHER = this.getFROM_METHOD_MATCHER();
        result = result * 59 + ($FROM_METHOD_MATCHER == null ? 43 : $FROM_METHOD_MATCHER.hashCode());
        return result;
    }
}

