/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes;

import com.atlassian.platform.recipes.ReplaceCompositeArgumentMethodInvocationVisitor;
import com.atlassian.platform.recipes.model.ArgumentTypeRefactor;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ChangeVariableType
extends ReplaceCompositeArgumentMethodInvocationVisitor {
    String variableNameToChange;

    public ChangeVariableType(String simpleName, ArgumentTypeRefactor firstLevel, ArgumentTypeRefactor secondLevel) {
        super(firstLevel, secondLevel);
        this.variableNameToChange = simpleName;
    }

    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration multiVariable, ExecutionContext executionContext) {
        multiVariable = super.visitMethodDeclaration(multiVariable, (Object)executionContext);
        JavaType.Method methodDec = multiVariable.getMethodType();
        ArrayList<JavaType> replacedParamTypes = new ArrayList<JavaType>(methodDec.getParameterTypes());
        for (int i = 0; i < methodDec.getParameterNames().size(); ++i) {
            if (!this.variableNameToChange.equals(methodDec.getParameterNames().get(i))) continue;
            replacedParamTypes.remove(i);
            replacedParamTypes.add(i, this.firstLevelRefactor.getTo());
            break;
        }
        if (this.variableNameToChange.equals((multiVariable = multiVariable.withMethodType(methodDec = methodDec.withParameterTypes(replacedParamTypes))).getName().getSimpleName()) && this.firstLevelRefactor.matchesType(multiVariable.getType())) {
            multiVariable = multiVariable.withType(this.firstLevelRefactor.getTo());
        }
        return multiVariable;
    }

    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
        multiVariable = super.visitVariableDeclarations(multiVariable, (Object)executionContext);
        List variablesAfter = ListUtils.map((List)multiVariable.getVariables(), this::changeTypeIfNeeded);
        multiVariable = multiVariable.withVariables(variablesAfter).withTypeExpression(this.firstLevelRefactor.transformIfMatches(multiVariable.getTypeExpression()));
        return multiVariable;
    }

    private J.VariableDeclarations.NamedVariable changeTypeIfNeeded(J.VariableDeclarations.NamedVariable var) {
        if (this.variableNameToChange.equals(var.getName().getSimpleName()) && this.firstLevelRefactor.matchesType(var.getType())) {
            J.Identifier identifier = this.transformIdentifier(var.getName(), this.firstLevelRefactor);
            return var.withType(this.firstLevelRefactor.getTo()).withName(identifier).withInitializer(this.transformArg(var.getInitializer(), this.firstLevelRefactor, this.secondLevelRefactor)).withVariableType(var.getVariableType().withOwner(this.firstLevelRefactor.getTo()).withType(this.firstLevelRefactor.getTo()));
        }
        return var;
    }
}

