/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes.model;

import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ArgumentTypeRefactor {
    private final TypeMatcher fromTypeMatcher;
    private final JavaType.FullyQualified fromTypeFullyQualified;
    private final String toSimpleName;
    private final JavaType to;
    private final JavaType.FullyQualified toTypeFullyQualified;

    public ArgumentTypeRefactor(String fromStr, String toStr) {
        this.fromTypeMatcher = new TypeMatcher(fromStr);
        this.fromTypeFullyQualified = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)fromStr));
        this.to = JavaType.buildType((String)toStr);
        this.toTypeFullyQualified = TypeUtils.asFullyQualified((JavaType)this.to);
        this.toSimpleName = toStr.substring(toStr.lastIndexOf(".") + 1);
    }

    public JavaType getTo() {
        return this.to;
    }

    public JavaType.FullyQualified getToTypeFullyQualified() {
        return this.toTypeFullyQualified;
    }

    public String getToSimpleName() {
        return this.toSimpleName;
    }

    public JavaType.FullyQualified getFromTypeFullyQualified() {
        return this.fromTypeFullyQualified;
    }

    public boolean matchesType(JavaType type) {
        return this.fromTypeMatcher.matches(type);
    }

    public JavaType transformIfMatches(JavaType type) {
        if (type != null && this.matchesType(type)) {
            return this.to;
        }
        return type;
    }

    public TypeTree transformIfMatches(TypeTree type) {
        if (type != null && this.matchesType(type.getType())) {
            return TypeTree.build((String)this.toSimpleName);
        }
        return type;
    }
}

