/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.recipes.rest.tov2;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddTagToAtlassianPluginXml
extends Recipe {
    private final FindSourceFiles PLUGIN_FILE_MATCHER = new FindSourceFiles("**/atlassian-plugin.xml");

    public String getDisplayName() {
        return "Add rest v2 tag to the dependency";
    }

    public String getDescription() {
        return "Add rest v2 tag to the atlassian-plugins.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)this.PLUGIN_FILE_MATCHER, (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher = new XPathMatcher("/atlassian-plugin");

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (this.xPathMatcher.matches(this.getCursor()) && t.getChild("rest").isPresent()) {
                    String pluginName = t.getAttributes().stream().filter(a -> "name".equals(a.getKeyAsString())).findFirst().orElseThrow().getValueAsString();
                    String migrationKey = pluginName + "-rest-migration";
                    String migrationTagStr = String.format("<rest-migration key=\"%s\">\n  <rest-v2/>\n</rest-migration>\n", migrationKey);
                    t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)Xml.Tag.build((String)migrationTagStr), (Cursor)this.getCursor());
                }
                return t;
            }
        });
    }

    public FindSourceFiles getPLUGIN_FILE_MATCHER() {
        return this.PLUGIN_FILE_MATCHER;
    }

    public String toString() {
        return "AddTagToAtlassianPluginXml(PLUGIN_FILE_MATCHER=" + this.getPLUGIN_FILE_MATCHER() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTagToAtlassianPluginXml)) {
            return false;
        }
        AddTagToAtlassianPluginXml other = (AddTagToAtlassianPluginXml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FindSourceFiles this$PLUGIN_FILE_MATCHER = this.getPLUGIN_FILE_MATCHER();
        FindSourceFiles other$PLUGIN_FILE_MATCHER = other.getPLUGIN_FILE_MATCHER();
        return !(this$PLUGIN_FILE_MATCHER == null ? other$PLUGIN_FILE_MATCHER != null : !this$PLUGIN_FILE_MATCHER.equals(other$PLUGIN_FILE_MATCHER));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddTagToAtlassianPluginXml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FindSourceFiles $PLUGIN_FILE_MATCHER = this.getPLUGIN_FILE_MATCHER();
        result = result * 59 + ($PLUGIN_FILE_MATCHER == null ? 43 : $PLUGIN_FILE_MATCHER.hashCode());
        return result;
    }
}

