/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.FlushableHttpCacheStorage;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.ProxySelectorAsyncRoutePlanner;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.api.factory.SettableFutureHandler;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.RequestKiller;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClient
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final HttpClientOptions httpClientOptions;
    private final RequestKiller requestKiller;
    private final HttpAsyncClient httpClient;
    private final HttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties) {
        this(eventPublisher, applicationProperties, new HttpClientOptions());
    }

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, HttpClientOptions options) {
        DefaultHttpAsyncClient client;
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.httpClientOptions = (HttpClientOptions)Preconditions.checkNotNull((Object)options);
        this.requestKiller = new RequestKiller(options.getThreadPrefix());
        try {
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(options.getIoThreadCount());
            ioReactorConfig.setSelectInterval(options.getIoSelectInterval());
            ioReactorConfig.setInterestOpQueued(true);
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    DefaultHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                public boolean handle(RuntimeException ex) {
                    DefaultHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            PoolingClientAsyncConnectionManager connmgr = new PoolingClientAsyncConnectionManager((ConnectingIOReactor)reactor, AsyncSchemeRegistryFactory.createDefault(), options.getConnectionPoolTimeToLive(), TimeUnit.MILLISECONDS){

                protected void finalize() throws Throwable {
                }
            };
            connmgr.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            client = new DefaultHttpAsyncClient((ClientAsyncConnectionManager)connmgr);
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
        HttpParams params = client.getParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent(options));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)options.getConnectionTimeout()));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)((int)options.getSocketTimeout()));
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        ProxySelectorAsyncRoutePlanner routePlanner = new ProxySelectorAsyncRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(options.getMaxCacheEntries());
        cacheConfig.setSharedCache(false);
        cacheConfig.setMaxObjectSize(options.getMaxCacheObjectSize());
        cacheConfig.setNeverCache1_0ResponsesWithQueryString(false);
        this.nonCachingHttpClient = client;
        this.httpCacheStorage = new FlushableHttpCacheStorage(cacheConfig);
        this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)client, (HttpCacheStorage)this.httpCacheStorage, cacheConfig);
        this.httpClient.start();
        this.requestKiller.start();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s-%s (%s) / %s", MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api"), this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber(), options.getUserAgent());
    }

    @Override
    public final ResponsePromise execute(DefaultRequest request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            SettableFuture future = SettableFuture.create();
            future.setException(t);
            return ResponsePromises.toResponsePromise((ListenableFuture)future);
        }
    }

    private ResponsePromise doExecute(DefaultRequest request) {
        HttpGet op;
        this.httpClientOptions.getRequestPreparer().apply((Object)request);
        request.validate();
        request.freeze();
        long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            if (op instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)op).setEntity(request.getHttpEntity());
            } else {
                throw new UnsupportedOperationException("HTTP method " + method + " does not support sending an entity");
            }
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            op.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        BasicHttpContext localContext = new BasicHttpContext();
        SettableFutureHandler future = this.httpClientOptions.getResponseSettableFutureHandlerFactory().create();
        FutureCallback<HttpResponse> futureCallback = new FutureCallback<HttpResponse>((HttpRequestBase)op, start, uri, request, future){
            final /* synthetic */ HttpRequestBase val$op;
            final /* synthetic */ long val$start;
            final /* synthetic */ String val$uri;
            final /* synthetic */ DefaultRequest val$request;
            final /* synthetic */ SettableFutureHandler val$future;
            {
                this.val$op = httpRequestBase;
                this.val$start = l;
                this.val$uri = string;
                this.val$request = defaultRequest;
                this.val$future = settableFutureHandler;
            }

            public void completed(HttpResponse httpResponse) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long elapsed = System.currentTimeMillis() - this.val$start;
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestCompletedEvent(this.val$uri, statusCode, elapsed, this.val$request.getAttributes()));
                } else {
                    DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, statusCode, elapsed, this.val$request.getAttributes()));
                }
                try {
                    DefaultResponse response = DefaultHttpClient.this.translate(httpResponse);
                    response.freeze();
                    this.val$future.set((Object)response);
                }
                catch (IOException ex) {
                    this.failed(ex);
                }
            }

            public void failed(Exception ex) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long elapsed = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, ex.toString(), elapsed, this.val$request.getAttributes()));
                this.val$future.setException((Throwable)ex);
            }

            public void cancelled() {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                TimeoutException ex = new TimeoutException();
                long elapsed = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, ex.toString(), elapsed, this.val$request.getAttributes()));
                this.val$future.setException((Throwable)ex);
            }
        };
        this.requestKiller.registerRequest((AbortableHttpRequest)op, this.httpClientOptions.getRequestTimeout());
        HttpAsyncClient actualClient = request.isCacheDisabled() ? this.nonCachingHttpClient : this.httpClient;
        actualClient.execute((HttpUriRequest)op, (HttpContext)localContext, (FutureCallback)futureCallback);
        return ResponsePromises.toResponsePromise((ListenableFuture)future.getFuture());
    }

    public void destroy() throws Exception {
        this.requestKiller.stop();
        this.httpClient.getConnectionManager().shutdown();
    }

    private DefaultResponse translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse response = new DefaultResponse(this.httpClientOptions.getMaxEntitySize());
        response.setStatusCode(status.getStatusCode());
        response.setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            response.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response.setEntityStream(entity.getContent());
        }
        return response;
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpCacheStorage.flushByUriPattern(urlPattern);
    }
}

