/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.base;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class RequestKiller
implements Runnable,
InitializingBean,
DisposableBean {
    private final Set<RequestEntry> activeRequests = new CopyOnWriteArraySet<RequestEntry>();
    private final Thread killerThread = new Thread((Runnable)this, "http-request-killer");

    public void registerRequest(AbortableHttpRequest request, int secondsToLive) {
        RequestEntry entry = new RequestEntry(request, secondsToLive);
        this.activeRequests.add(entry);
    }

    public void afterPropertiesSet() throws Exception {
        this.killerThread.start();
    }

    public void destroy() throws Exception {
        this.killerThread.interrupt();
    }

    @Override
    public void run() {
        while (true) {
            HashSet entriesToRemove = Sets.newHashSet();
            long now = System.currentTimeMillis();
            for (RequestEntry entry : this.activeRequests) {
                if (now <= entry.getExpiry()) continue;
                entry.abort();
                entriesToRemove.add(entry);
            }
            this.activeRequests.removeAll(entriesToRemove);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void completedRequest(AbortableHttpRequest request) {
        this.activeRequests.remove(new RequestEntry(request));
    }

    private static final class RequestEntry {
        private final AbortableHttpRequest request;
        private final long expiry;

        private RequestEntry(AbortableHttpRequest request) {
            this.request = request;
            this.expiry = 0L;
        }

        private RequestEntry(AbortableHttpRequest request, int secondsToLive) {
            this.request = request;
            this.expiry = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(secondsToLive);
        }

        public void abort() {
            this.request.abort();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestEntry that = (RequestEntry)o;
            return this.request.equals(that.request);
        }

        public int hashCode() {
            return this.request.hashCode();
        }

        public long getExpiry() {
            return this.expiry;
        }
    }
}

