/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.Response;
import java.io.InputStream;
import java.util.Map;

public final class DefaultResponse
extends DefaultMessage
implements Response {
    private int statusCode;
    private String statusText;

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response setStatusCode(int statusCode) {
        this.checkMutable();
        this.statusCode = statusCode;
        return this;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Response setStatusText(String statusText) {
        this.checkMutable();
        this.statusText = statusText;
        return this;
    }

    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }

    public boolean isCreated() {
        return this.statusCode == 201;
    }

    public boolean isNoContent() {
        return this.statusCode == 204;
    }

    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean isSeeOther() {
        return this.statusCode == 303;
    }

    public boolean isNotModified() {
        return this.statusCode == 304;
    }

    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isBadRequest() {
        return this.statusCode == 400;
    }

    public boolean isUnauthorized() {
        return this.statusCode == 401;
    }

    public boolean isForbidden() {
        return this.statusCode == 403;
    }

    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    public boolean isConflict() {
        return this.statusCode == 409;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    public boolean isInternalServerError() {
        return this.statusCode == 500;
    }

    public boolean isServiceUnavailable() {
        return this.statusCode == 503;
    }

    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public boolean isNotSuccessful() {
        return this.isInformational() || this.isRedirection() || this.isError();
    }

    public Response setContentType(String contentType) {
        this.checkMutable();
        super.setContentType(contentType);
        return this;
    }

    public Response setContentCharset(String contentCharset) {
        this.checkMutable();
        super.setContentCharset(contentCharset);
        return this;
    }

    public Response setHeaders(Map<String, String> headers) {
        this.checkMutable();
        super.setHeaders(headers);
        return this;
    }

    public Response setHeader(String name, String value) {
        this.checkMutable();
        super.setHeader(name, value);
        return this;
    }

    public Response setEntity(String entity) {
        this.checkMutable();
        super.setEntity(entity);
        return this;
    }

    public Response setEntityStream(InputStream entityStream, String encoding) {
        this.checkMutable();
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    public Response setEntityStream(InputStream entityStream) {
        this.checkMutable();
        super.setEntityStream(entityStream);
        return this;
    }

    protected Response freeze() {
        super.freeze();
        return this;
    }
}

