/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.concurrent.DefaultSettableFutureHandler;
import com.atlassian.httpclient.base.concurrent.SettableFutureHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DefaultRequest
extends DefaultMessage
implements Request {
    private AbstractHttpClient httpClient;
    private Method method;
    private URI uri;
    private Map<String, String> attributes;
    private SettableFutureHandler<Response> settableFutureHandler;

    public DefaultRequest(AbstractHttpClient httpClient) {
        this.httpClient = httpClient;
        this.attributes = Maps.newHashMap();
        this.settableFutureHandler = new DefaultSettableFutureHandler<Response>();
        this.setAccept("*/*");
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri) {
        this(httpClient, uri, null, null);
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri, String contentType, String entity) {
        this(httpClient);
        this.setUri(uri).setContentType(contentType).setEntity(entity);
    }

    public void setSettableFutureHandler(SettableFutureHandler<Response> futureHandler) {
        this.settableFutureHandler = futureHandler;
    }

    public SettableFutureHandler<Response> getSettableFutureHandler() {
        return this.settableFutureHandler;
    }

    public ResponsePromise get() {
        this.setMethod(Method.GET);
        return this.httpClient.execute(this);
    }

    public ResponsePromise post() {
        this.setMethod(Method.POST);
        return this.httpClient.execute(this);
    }

    public ResponsePromise put() {
        this.setMethod(Method.PUT);
        return this.httpClient.execute(this);
    }

    public ResponsePromise delete() {
        this.setMethod(Method.DELETE);
        return this.httpClient.execute(this);
    }

    public ResponsePromise options() {
        this.setMethod(Method.OPTIONS);
        return this.httpClient.execute(this);
    }

    public ResponsePromise head() {
        this.setMethod(Method.HEAD);
        return this.httpClient.execute(this);
    }

    public ResponsePromise trace() {
        this.setMethod(Method.TRACE);
        return this.httpClient.execute(this);
    }

    public Method getMethod() {
        return this.method;
    }

    private Request setMethod(Method method) {
        this.checkMutable();
        this.method = method;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public Request setUri(URI uri) {
        this.checkMutable();
        this.uri = uri;
        return this;
    }

    public String getAccept() {
        return this.getHeader("Accept");
    }

    public Request setAccept(String accept) {
        this.checkMutable();
        this.setHeader("Accept", accept);
        return this;
    }

    public Request setAttribute(String name, String value) {
        this.checkMutable();
        this.attributes.put(name, value);
        return this;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Request setEntity(EntityBuilder entityBuilder) {
        EntityBuilder.Entity entity = entityBuilder.build();
        return this.setHeaders((Map<String, String>)entity.getHeaders()).setEntityStream(entity.getInputStream());
    }

    public Request validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.uri);
        Preconditions.checkNotNull((Object)((Object)this.method));
        switch (this.method) {
            case GET: 
            case DELETE: 
            case HEAD: {
                if (!this.hasEntity()) break;
                throw new IllegalStateException("Request method " + (Object)((Object)this.method) + " does not support an entity");
            }
            case POST: 
            case PUT: 
            case TRACE: {
                if (this.hasEntity()) break;
                throw new IllegalStateException("Request method " + (Object)((Object)this.method) + " requires an entity");
            }
        }
        return this;
    }

    public Request setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    public Request setContentCharset(String contentCharset) {
        super.setContentCharset(contentCharset);
        return this;
    }

    public Request setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        return this;
    }

    public Request setHeader(String name, String value) {
        super.setHeader(name, value);
        return this;
    }

    public Request setEntity(String entity) {
        super.setEntity(entity);
        return this;
    }

    public Request setEntityStream(InputStream entityStream, String encoding) {
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    public Request setEntityStream(InputStream entityStream) {
        super.setEntityStream(entityStream);
        return this;
    }

    protected Request freeze() {
        super.freeze();
        return this;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        TRACE;

    }
}

