/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.ProxySelectorAsyncRoutePlanner;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.RequestKiller;
import com.atlassian.httpclient.base.concurrent.SettableFutureHandler;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.util.concurrent.ThreadFactories;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultHttpClient
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RequestKiller requestKiller;
    private final EventPublisher eventPublisher;
    private final HttpAsyncClient httpClient;

    public DefaultHttpClient(RequestKiller requestKiller, EventPublisher eventPublisher) {
        DefaultHttpAsyncClient client;
        this.requestKiller = requestKiller;
        this.eventPublisher = eventPublisher;
        try {
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(10);
            ioReactorConfig.setSelectInterval(100L);
            ioReactorConfig.setInterestOpQueued(true);
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)"ra-async-http", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    DefaultHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                public boolean handle(RuntimeException ex) {
                    DefaultHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            client = new DefaultHttpAsyncClient((ClientAsyncConnectionManager)new PoolingClientAsyncConnectionManager((ConnectingIOReactor)reactor, AsyncSchemeRegistryFactory.createDefault(), 3L, TimeUnit.SECONDS){

                protected void finalize() throws Throwable {
                }
            });
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor not set up correctly", e);
        }
        HttpParams params = client.getParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Atlassian-RemoteApps");
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        ProxySelectorAsyncRoutePlanner routePlanner = new ProxySelectorAsyncRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        this.httpClient = client;
        this.httpClient.start();
    }

    @Override
    public ResponsePromise execute(DefaultRequest request) {
        HttpGet op;
        request.validate();
        request.freeze();
        long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        DefaultRequest.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            if (op instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)op).setEntity(request.getHttpEntity());
            } else {
                throw new UnsupportedOperationException("HTTP method " + (Object)((Object)method) + " does not support sending an entity");
            }
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            op.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        BasicHttpContext localContext = new BasicHttpContext();
        SettableFutureHandler<Response> future = request.getSettableFutureHandler();
        FutureCallback<HttpResponse> futureCallback = new FutureCallback<HttpResponse>((HttpRequestBase)op, start, uri, request, future){
            final /* synthetic */ HttpRequestBase val$op;
            final /* synthetic */ long val$start;
            final /* synthetic */ String val$uri;
            final /* synthetic */ DefaultRequest val$request;
            final /* synthetic */ SettableFutureHandler val$future;
            {
                this.val$op = httpRequestBase;
                this.val$start = l;
                this.val$uri = string;
                this.val$request = defaultRequest;
                this.val$future = settableFutureHandler;
            }

            public void completed(HttpResponse httpResponse) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long elapsed = System.currentTimeMillis() - this.val$start;
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestCompletedEvent(this.val$uri, statusCode, elapsed, this.val$request.getAttributes()));
                } else {
                    DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, statusCode, elapsed, this.val$request.getAttributes()));
                }
                try {
                    DefaultResponse response = DefaultHttpClient.this.translate(httpResponse);
                    response.freeze();
                    this.val$future.set(response);
                }
                catch (IOException ex) {
                    this.failed(ex);
                }
            }

            public void failed(Exception ex) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long elapsed = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, ex.toString(), elapsed, this.val$request.getAttributes()));
                this.val$future.setException(ex);
            }

            public void cancelled() {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                TimeoutException ex = new TimeoutException();
                long elapsed = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.eventPublisher.publish((Object)new HttpRequestFailedEvent(this.val$uri, ex.toString(), elapsed, this.val$request.getAttributes()));
                this.val$future.setException(ex);
            }
        };
        this.requestKiller.registerRequest(new NotifyingAbortableHttpRequest((AbortableHttpRequest)op, (FutureCallback)futureCallback), 30);
        this.httpClient.execute((HttpUriRequest)op, (HttpContext)localContext, (FutureCallback)futureCallback);
        return ResponsePromises.toResponsePromise(future.getFuture());
    }

    public void destroy() throws Exception {
        this.httpClient.getConnectionManager().shutdown();
    }

    private DefaultResponse translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse response = new DefaultResponse();
        response.setStatusCode(status.getStatusCode());
        response.setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            response.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response.setEntityStream(entity.getContent());
        }
        return response;
    }

    private class NotifyingAbortableHttpRequest
    implements AbortableHttpRequest {
        private final AbortableHttpRequest delegate;
        private final FutureCallback<HttpResponse> callback;

        private NotifyingAbortableHttpRequest(AbortableHttpRequest delegate, FutureCallback<HttpResponse> callback) {
            this.delegate = delegate;
            this.callback = callback;
        }

        public void setConnectionRequest(ClientConnectionRequest connRequest) throws IOException {
            this.delegate.setConnectionRequest(connRequest);
        }

        public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
            this.delegate.setReleaseTrigger(releaseTrigger);
        }

        public void abort() {
            this.delegate.abort();
            this.callback.cancelled();
        }
    }
}

