/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.base;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.AbortableHttpRequest;

public final class RequestKiller
implements Runnable {
    private final Set<RequestEntry> activeRequests = new CopyOnWriteArraySet<RequestEntry>();
    private final Thread killerThread;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public RequestKiller(String namePrefix) {
        this.killerThread = new Thread((Runnable)this, namePrefix + "-req-killer");
    }

    public void registerRequest(AbortableHttpRequest request, long millisToLive) {
        RequestEntry entry = new RequestEntry(request, millisToLive);
        this.activeRequests.add(entry);
    }

    public void start() {
        this.killerThread.start();
    }

    public void stop() throws Exception {
        this.destroyed.set(true);
        this.killerThread.interrupt();
    }

    @Override
    public void run() {
        while (!this.destroyed.get()) {
            HashSet entriesToRemove = Sets.newHashSet();
            long now = System.currentTimeMillis();
            for (RequestEntry entry : this.activeRequests) {
                if (now <= entry.getExpiry()) continue;
                entry.abort();
                entriesToRemove.add(entry);
            }
            this.activeRequests.removeAll(entriesToRemove);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void completedRequest(AbortableHttpRequest request) {
        this.activeRequests.remove(new RequestEntry(request));
    }

    private static final class RequestEntry {
        private final AbortableHttpRequest request;
        private final long expiry;

        private RequestEntry(AbortableHttpRequest request) {
            this.request = request;
            this.expiry = 0L;
        }

        private RequestEntry(AbortableHttpRequest request, long millisToLive) {
            this.request = request;
            this.expiry = System.currentTimeMillis() + millisToLive;
        }

        public void abort() {
            this.request.abort();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestEntry that = (RequestEntry)o;
            return this.request.equals(that.request);
        }

        public int hashCode() {
            return this.request.hashCode();
        }

        public long getExpiry() {
            return this.expiry;
        }
    }
}

