package com.atlassian.event.internal;

final class StringUtils {

    private StringUtils() {}

    /**
     * Calls the object's toString() method. If an exception is thrown from the object's toString() method then this
     * method falls back to the "identity" toString() (as per JVM defaults).
     *
     * @param object an Object
     * @return a human-readable String representation of the object
     */
    public static String paranoidToString(Object object) {
        try {
            return String.valueOf(object);
        } catch (RuntimeException e) {
            return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
        }
    }
}
