/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.AuthenticationState;
import com.atlassian.crowd.integration.http.AbstractCrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.NoOpTokenLockProvider;
import com.atlassian.crowd.integration.http.TokenLockProvider;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.Session;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import java.security.Principal;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrowdHttpAuthenticatorImpl
extends AbstractCrowdHttpAuthenticator {
    protected final TokenLockProvider tokenLockProvider;

    public CrowdHttpAuthenticatorImpl(CrowdClient client, ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper) {
        this(client, clientProperties, tokenHelper, new NoOpTokenLockProvider());
    }

    public CrowdHttpAuthenticatorImpl(CrowdClient client, ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper, TokenLockProvider tokenLockProvider) {
        super(client, clientProperties, tokenHelper);
        this.tokenLockProvider = tokenLockProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public AuthenticationState checkAuthenticated(HttpServletRequest request, HttpServletResponse response) throws OperationFailedException {
        if (!this.shouldRevalidateSession(request)) {
            return AuthenticationState.authenticated();
        }
        String token = this.getToken(request);
        if (token == null) {
            LOGGER.debug("Non authenticated request, unable to find a valid Crowd token.");
            return AuthenticationState.unauthenticated();
        }
        Lock lockForToken = this.tokenLockProvider.getLock(token);
        lockForToken.lock();
        try {
            if (!this.shouldRevalidateSession(request)) {
                AuthenticationState authenticationState = AuthenticationState.authenticated();
                return authenticationState;
            }
            Session crowdSession = this.client.validateSSOAuthenticationAndGetSession(token, this.tokenHelper.getValidationFactorExtractor().getValidationFactors(request));
            CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
            this.tokenHelper.setCrowdToken(request, response, token, this.clientProperties, cookieConfig);
            Principal principal = crowdSession.getUser();
            AuthenticationState authenticationState = AuthenticationState.authenticated(principal);
            return authenticationState;
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException | InvalidTokenException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), e);
            }
            AuthenticationState authenticationState = AuthenticationState.unauthenticated();
            return authenticationState;
        }
        finally {
            lockForToken.unlock();
        }
    }
}

