/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.AuthenticationState;
import com.atlassian.crowd.integration.http.AbstractCrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.authentication.Session;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.Principal;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedCrowdHttpAuthenticatorImpl
extends AbstractCrowdHttpAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedCrowdHttpAuthenticatorImpl.class);
    private final Cache<String, AuthenticationState> authenticationStateCache = this.createAuthenticationStateCache();

    public CachedCrowdHttpAuthenticatorImpl(CrowdClient client, ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper) {
        super(client, clientProperties, tokenHelper);
    }

    @Override
    @Nonnull
    public AuthenticationState checkAuthenticated(HttpServletRequest request, HttpServletResponse response) throws OperationFailedException {
        AuthenticationState lastAuthenticationState = this.getLastAuthenticationStateIfActual(request);
        if (lastAuthenticationState != null) {
            LOGGER.debug("Got last authentication state: {}. Returning it.", (Object)lastAuthenticationState);
            return lastAuthenticationState;
        }
        String token = this.getToken(request);
        if (token == null) {
            LOGGER.debug("Non authenticated request, unable to find a valid Crowd token.");
            return AuthenticationState.unauthenticated();
        }
        try {
            return (AuthenticationState)this.authenticationStateCache.get((Object)token, () -> {
                try {
                    LOGGER.debug("Revalidating Crowd Token: {}", (Object)token);
                    return this.validateCrowdToken(request, response, token);
                }
                catch (ApplicationPermissionException | InvalidAuthenticationException | InvalidTokenException e) {
                    return this.handleSsoAuthenticationValidationFailedResults(token, (Exception)e);
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OperationFailedException) {
                throw (OperationFailedException)e.getCause();
            }
            throw new OperationFailedException("Authentication failed", e.getCause());
        }
    }

    private AuthenticationState validateCrowdToken(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidTokenException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        Session crowdSession = this.client.validateSSOAuthenticationAndGetSession(token, this.tokenHelper.getValidationFactorExtractor().getValidationFactors(request));
        return this.handleSsoAuthenticationValidationSucceedResults(token, crowdSession, request, response);
    }

    private Cache<String, AuthenticationState> createAuthenticationStateCache() {
        Validate.notNull((Object)this.clientProperties, (String)"clientProperties cannot be null", (Object[])new Object[0]);
        return CacheBuilder.newBuilder().expireAfterWrite(this.clientProperties.getAuthenticationStateCacheTtlMinutes(), TimeUnit.MINUTES).build();
    }

    private AuthenticationState handleSsoAuthenticationValidationSucceedResults(String token, Session crowdSession, HttpServletRequest request, HttpServletResponse response) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        this.tokenHelper.setCrowdToken(request, response, token, this.clientProperties, this.client.getCookieConfiguration());
        Principal principal = crowdSession.getUser();
        return AuthenticationState.authenticated(principal);
    }

    private AuthenticationState handleSsoAuthenticationValidationFailedResults(String token, Exception e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return AuthenticationState.unauthenticated();
    }

    @Nullable
    private AuthenticationState getLastAuthenticationStateIfActual(HttpServletRequest request) {
        boolean shouldRevalidateSession = this.shouldRevalidateSession(request);
        if (!shouldRevalidateSession) {
            return AuthenticationState.authenticated();
        }
        String token = this.getToken(request);
        if (token == null) {
            return null;
        }
        return this.getStateFromCacheAndInvalidateCacheIfNeeded(request, token);
    }

    @Nullable
    private AuthenticationState getStateFromCacheAndInvalidateCacheIfNeeded(HttpServletRequest request, String token) {
        AuthenticationState authenticationStateFromCache = (AuthenticationState)this.authenticationStateCache.getIfPresent((Object)token);
        if (authenticationStateFromCache != null && authenticationStateFromCache.isAuthenticated() && this.shouldRevalidateSession(request)) {
            LOGGER.debug("Invalidating authenticationStateCache for {} token", (Object)token);
            this.authenticationStateCache.invalidate((Object)token);
            return null;
        }
        return authenticationStateFromCache;
    }
}

